/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElement;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class TurbineRoundEnvironment
implements RoundEnvironment {
    private final ModelFactory factory;
    private final ImmutableSet<ClassSymbol> syms;
    private final boolean processingOver;
    private final boolean errorRaised;
    private final ImmutableSetMultimap<ClassSymbol, Symbol> allAnnotations;
    private final Supplier<ImmutableSet<TurbineElement.TurbineTypeElement>> rootElements = Suppliers.memoize(new Supplier<ImmutableSet<TurbineElement.TurbineTypeElement>>(){

        @Override
        public ImmutableSet<TurbineElement.TurbineTypeElement> get() {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (ClassSymbol sym : TurbineRoundEnvironment.this.syms) {
                if (sym.simpleName().contains("$") && TurbineRoundEnvironment.this.factory.getSymbol(sym).owner() != null || sym.simpleName().equals("package-info")) continue;
                result.add(TurbineRoundEnvironment.this.factory.typeElement(sym));
            }
            return result.build();
        }
    });

    public TurbineRoundEnvironment(ModelFactory factory, ImmutableSet<ClassSymbol> syms, boolean processingOver, boolean errorRaised, ImmutableSetMultimap<ClassSymbol, Symbol> allAnnotations) {
        this.factory = factory;
        this.syms = syms;
        this.processingOver = processingOver;
        this.errorRaised = errorRaised;
        this.allAnnotations = allAnnotations;
    }

    @Override
    public boolean processingOver() {
        return this.processingOver;
    }

    @Override
    public boolean errorRaised() {
        return this.errorRaised;
    }

    public ImmutableSet<TurbineElement.TurbineTypeElement> getRootElements() {
        return this.rootElements.get();
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
        return this.factory.elements((ImmutableSet<? extends Symbol>)this.allAnnotations.get((Object)((TurbineElement.TurbineTypeElement)a).sym()));
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
        return this.getElementsAnnotatedWith(this.factory.typeElement(new ClassSymbol(a.getName().replace('.', '/'))));
    }
}

