/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.Const;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineAnnotationMirror;
import com.google.turbine.processing.TurbineAnnotationValueMirror;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import java.util.Iterator;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jspecify.nullness.Nullable;

public class TurbineMessager
implements Messager {
    private final ModelFactory factory;
    private final TurbineLog log;

    public TurbineMessager(ModelFactory factory, TurbineLog log) {
        this.factory = factory;
        this.log = log;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
        this.log.diagnostic(kind, String.valueOf(msg));
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
        if (e == null || e instanceof TurbineElement.TurbineNoTypeElement) {
            this.printMessage(kind, msg);
            return;
        }
        Symbol sym = ((TurbineElement)e).sym();
        SourceFile source = this.getSource(sym);
        int position = this.getPosition(sym);
        this.log.withSource(source).diagnostic(kind, position, TurbineError.ErrorKind.PROC, msg);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
        if (a == null || e == null || e instanceof TurbineElement.TurbineNoTypeElement) {
            this.printMessage(kind, msg, e);
            return;
        }
        SourceFile source = this.getSource(((TurbineElement)e).sym());
        int position = ((TurbineAnnotationMirror)a).anno().tree().position();
        this.log.withSource(source).diagnostic(kind, position, TurbineError.ErrorKind.PROC, msg);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        if (a == null || e == null || e instanceof TurbineElement.TurbineNoTypeElement || v == null) {
            this.printMessage(kind, msg, e, a);
            return;
        }
        SourceFile source = this.getSource(((TurbineElement)e).sym());
        AnnoInfo anno = ((TurbineAnnotationMirror)a).anno();
        int position = TurbineMessager.locateInAnnotation(((TurbineAnnotationValueMirror)v).value(), anno);
        if (position == -1) {
            position = anno.tree().position();
        }
        this.log.withSource(source).diagnostic(kind, position, TurbineError.ErrorKind.PROC, msg);
    }

    private @Nullable SourceFile getSource(Symbol sym) {
        ClassSymbol encl = ModelFactory.enclosingClass(sym);
        TypeBoundClass info = this.factory.getSymbol(encl);
        if (!(info instanceof SourceTypeBoundClass)) {
            return null;
        }
        return ((SourceTypeBoundClass)info).source();
    }

    private int getPosition(Symbol sym) {
        switch (sym.symKind()) {
            case CLASS: {
                return this.classPosition((ClassSymbol)sym);
            }
            case TY_PARAM: {
                return this.tyParamPosition((TyVarSymbol)sym);
            }
            case METHOD: {
                return this.methodPosition((MethodSymbol)sym);
            }
            case FIELD: {
                return this.fieldPosition((FieldSymbol)sym);
            }
            case PARAMETER: {
                return this.paramPosition((ParamSymbol)sym);
            }
            case RECORD_COMPONENT: {
                return -1;
            }
        }
        throw new AssertionError((Object)sym.symKind());
    }

    private int fieldPosition(FieldSymbol sym) {
        Tree.VarDecl decl = this.factory.getFieldInfo(sym).decl();
        return decl != null ? decl.position() : -1;
    }

    private int paramPosition(ParamSymbol sym) {
        TypeBoundClass.MethodInfo minfo = this.factory.getMethodInfo(sym.owner());
        if (minfo.decl() == null) {
            return -1;
        }
        int idx = minfo.parameters().indexOf(this.factory.getParamInfo(sym));
        return ((Tree.VarDecl)minfo.decl().params().get(idx)).position();
    }

    private int methodPosition(MethodSymbol sym) {
        TypeBoundClass.MethodInfo methodInfo = this.factory.getMethodInfo(sym);
        Tree.MethDecl decl = methodInfo.decl();
        if (decl != null) {
            return decl.position();
        }
        int position = this.classPosition(sym.owner());
        if (position == -1) {
            return -1;
        }
        return position -= 6;
    }

    private int classPosition(ClassSymbol owner) {
        TypeBoundClass symbol = this.factory.getSymbol(owner);
        if (!(symbol instanceof SourceTypeBoundClass)) {
            return -1;
        }
        return ((SourceTypeBoundClass)symbol).decl().position();
    }

    private int tyParamPosition(TyVarSymbol sym) {
        ImmutableList<Tree.TyParam> trees;
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tyVars;
        TyVarSymbol tyVarSymbol = sym;
        Symbol owner = tyVarSymbol.owner();
        switch (owner.symKind()) {
            case CLASS: {
                TypeBoundClass cinfo = this.factory.getSymbol((ClassSymbol)owner);
                if (!(cinfo instanceof SourceTypeBoundClass)) {
                    return -1;
                }
                tyVars = cinfo.typeParameterTypes();
                trees = ((SourceTypeBoundClass)cinfo).decl().typarams();
                break;
            }
            case METHOD: {
                TypeBoundClass.MethodInfo minfo = this.factory.getMethodInfo((MethodSymbol)owner);
                if (minfo.decl() == null) {
                    return -1;
                }
                tyVars = minfo.tyParams();
                trees = minfo.decl().typarams();
                break;
            }
            default: {
                throw new AssertionError((Object)owner.symKind());
            }
        }
        return ((Tree.TyParam)trees.get(((ImmutableCollection)((Object)tyVars.keySet())).asList().indexOf(tyVarSymbol))).position();
    }

    private static int locateInAnnotation(Const v, AnnoInfo anno) {
        return TurbineMessager.locate(v, ((ImmutableCollection)anno.values().values()).asList(), anno.tree().args());
    }

    private static int locate(Const toFind, Const v, Tree.Expression t) {
        Tree.Expression expression = t = t.kind().equals((Object)Tree.Kind.ASSIGN) ? ((Tree.Assign)t).expr() : t;
        if (toFind.equals(v)) {
            return t.position();
        }
        switch (v.kind()) {
            case ARRAY: {
                ImmutableList<Tree.Expression> elements = t.kind().equals((Object)Tree.Kind.ARRAY_INIT) ? ((Tree.ArrayInit)t).exprs() : ImmutableList.of(t);
                return TurbineMessager.locate(toFind, ((Const.ArrayInitValue)v).elements(), elements);
            }
            case ANNOTATION: {
                return TurbineMessager.locateInAnnotation(toFind, ((TurbineAnnotationValue)v).info());
            }
        }
        return -1;
    }

    private static int locate(Const toFind, ImmutableList<Const> vx, ImmutableList<Tree.Expression> tx) {
        Iterator vi = vx.iterator();
        Iterator ti = tx.iterator();
        while (vi.hasNext()) {
            int result = TurbineMessager.locate(toFind, (Const)vi.next(), (Tree.Expression)ti.next());
            if (result == -1) continue;
            return result;
        }
        return -1;
    }
}

