/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.processing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.type.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ClassHierarchy {
    private final Map<ClassSymbol, HierarchyNode> cache = new HashMap<ClassSymbol, HierarchyNode>();
    private Env<ClassSymbol, ? extends TypeBoundClass> env;

    ClassHierarchy(Env<ClassSymbol, ? extends TypeBoundClass> env) {
        this.env = env;
    }

    public void round(CompoundEnv<ClassSymbol, TypeBoundClass> env) {
        this.cache.clear();
        this.env = env;
    }

    private HierarchyNode compute(ClassSymbol sym) {
        HierarchyNode node = new HierarchyNode(sym);
        TypeBoundClass info = this.env.get(sym);
        if (info == null) {
            throw TurbineError.format(null, TurbineError.ErrorKind.SYMBOL_NOT_FOUND, sym);
        }
        if (info.superClassType() != null) {
            node.add(info.superClassType());
        }
        for (Type type : info.interfaceTypes()) {
            node.add(type);
        }
        return node;
    }

    private HierarchyNode get(ClassSymbol sym) {
        HierarchyNode result = this.cache.get(sym);
        if (result != null) {
            return result;
        }
        result = this.compute(sym);
        this.cache.put(sym, result);
        return result;
    }

    ImmutableList<Type.ClassTy> search(Type t, ClassSymbol s) {
        if (t.tyKind() != Type.TyKind.CLASS_TY) {
            return ImmutableList.of();
        }
        Type.ClassTy classTy = (Type.ClassTy)t;
        if (classTy.sym().equals(s)) {
            return ImmutableList.of(classTy);
        }
        HierarchyNode node = this.get(classTy.sym());
        PathNode path = (PathNode)node.ancestors.get(s);
        if (path == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(classTy);
        while (path != null) {
            result.add(path.type);
            path = path.ancestor;
        }
        return ((ImmutableList)result.build()).reverse();
    }

    public Iterable<ClassSymbol> transitiveSupertypes(ClassSymbol s) {
        return Iterables.concat(ImmutableList.of(s), this.get(s).closure());
    }

    private class HierarchyNode {
        private final ClassSymbol sym;
        private final Map<ClassSymbol, PathNode> ancestors = new LinkedHashMap<ClassSymbol, PathNode>();

        HierarchyNode(ClassSymbol sym) {
            this.sym = sym;
        }

        private void add(Type type) {
            if (type.tyKind() != Type.TyKind.CLASS_TY) {
                return;
            }
            Type.ClassTy classTy = (Type.ClassTy)type;
            HierarchyNode child = ClassHierarchy.this.get(classTy.sym());
            PathNode existing = this.ancestors.putIfAbsent(child.sym, new PathNode(classTy, null));
            if (existing != null) {
                return;
            }
            for (Map.Entry<ClassSymbol, PathNode> n : child.ancestors.entrySet()) {
                this.ancestors.putIfAbsent(n.getKey(), new PathNode(classTy, n.getValue()));
            }
        }

        private Set<ClassSymbol> closure() {
            return this.ancestors.keySet();
        }
    }

    private static class PathNode {
        final Type.ClassTy type;
        final PathNode ancestor;

        PathNode(Type.ClassTy type, PathNode ancestor) {
            this.type = type;
            this.ancestor = ancestor;
        }
    }
}

