/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.Token;
import com.google.turbine.parse.UnicodeEscapePreprocessor;
import org.jspecify.nullness.Nullable;

public class StreamLexer
implements Lexer {
    private final UnicodeEscapePreprocessor reader;
    private int ch;
    private int position;
    private int readFrom;
    private String value = null;
    private String javadoc = null;

    public StreamLexer(UnicodeEscapePreprocessor reader) {
        this.reader = reader;
        this.eat();
    }

    private void saveValue(String value) {
        this.value = value;
    }

    private void readFrom() {
        this.value = null;
        this.readFrom = this.reader.position();
    }

    private void eat() {
        this.ch = this.reader.next();
    }

    @Override
    public @Nullable String javadoc() {
        String result = this.javadoc;
        this.javadoc = null;
        if (result == null) {
            return null;
        }
        Verify.verify(result.endsWith("*"), result, new Object[0]);
        return result.substring(0, result.length() - "*".length());
    }

    @Override
    public String stringValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.reader.readString(this.readFrom, this.reader.position());
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public SourceFile source() {
        return this.reader.source();
    }

    @Override
    public Token next() {
        block57: while (true) {
            this.position = this.reader.position();
            switch (this.ch) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.eat();
                    continue block57;
                }
                case 47: {
                    this.eat();
                    switch (this.ch) {
                        case 47: {
                            block58: while (true) {
                                this.eat();
                                switch (this.ch) {
                                    case 10: 
                                    case 13: {
                                        this.eat();
                                        continue block57;
                                    }
                                    case 26: {
                                        if (this.reader.done()) {
                                            return Token.EOF;
                                        }
                                        this.eat();
                                        continue block58;
                                    }
                                }
                            }
                        }
                        case 42: {
                            this.eat();
                            boolean sawStar = false;
                            boolean isJavadoc = false;
                            if (this.ch == 42) {
                                this.eat();
                                if (this.ch == 47) {
                                    this.eat();
                                    continue block57;
                                }
                                isJavadoc = true;
                                this.readFrom();
                            }
                            block59: while (true) {
                                switch (this.ch) {
                                    case 42: {
                                        this.eat();
                                        sawStar = true;
                                        continue block59;
                                    }
                                    case 47: {
                                        if (sawStar) {
                                            if (isJavadoc) {
                                                this.javadoc = this.stringValue();
                                                Verify.verify(this.javadoc.endsWith("*"), this.javadoc, new Object[0]);
                                            }
                                            this.eat();
                                            continue block57;
                                        }
                                        sawStar = false;
                                        this.eat();
                                        continue block59;
                                    }
                                    case 26: {
                                        if (this.reader.done()) {
                                            throw TurbineError.format(this.reader.source(), this.position, TurbineError.ErrorKind.UNCLOSED_COMMENT, new Object[0]);
                                        }
                                        this.eat();
                                        sawStar = false;
                                        continue block59;
                                    }
                                }
                                this.eat();
                                sawStar = false;
                            }
                        }
                    }
                    if (this.ch == 61) {
                        this.eat();
                        return Token.DIVEQ;
                    }
                    return Token.DIV;
                }
                case 36: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    return this.identifier();
                }
                case 26: {
                    if (!this.reader.done()) {
                        throw this.error(TurbineError.ErrorKind.UNEXPECTED_EOF, new Object[0]);
                    }
                    return Token.EOF;
                }
                case 33: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: 
                case 126: {
                    return this.operator();
                }
                case 40: {
                    this.eat();
                    return Token.LPAREN;
                }
                case 41: {
                    this.eat();
                    return Token.RPAREN;
                }
                case 123: {
                    this.eat();
                    return Token.LBRACE;
                }
                case 125: {
                    this.eat();
                    return Token.RBRACE;
                }
                case 91: {
                    this.eat();
                    return Token.LBRACK;
                }
                case 93: {
                    this.eat();
                    return Token.RBRACK;
                }
                case 59: {
                    this.eat();
                    return Token.SEMI;
                }
                case 44: {
                    this.eat();
                    return Token.COMMA;
                }
                case 64: {
                    this.eat();
                    return Token.AT;
                }
                case 48: {
                    this.readFrom();
                    this.eat();
                    switch (this.ch) {
                        case 88: 
                        case 120: {
                            this.eat();
                            return this.hexLiteral();
                        }
                        case 66: 
                        case 98: {
                            this.eat();
                            return this.boolLiteral();
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 95: {
                            return this.octalLiteral();
                        }
                        case 46: {
                            this.eat();
                            return this.floatLiteral();
                        }
                        case 70: 
                        case 102: {
                            this.eat();
                            return Token.FLOAT_LITERAL;
                        }
                        case 68: 
                        case 100: {
                            this.eat();
                            return Token.DOUBLE_LITERAL;
                        }
                        case 76: 
                        case 108: {
                            this.eat();
                            return Token.LONG_LITERAL;
                        }
                    }
                    return Token.INT_LITERAL;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.readFrom();
                    return this.decimalLiteral();
                }
                case 46: {
                    this.readFrom();
                    this.eat();
                    switch (this.ch) {
                        case 46: {
                            this.eat();
                            if (this.ch == 46) {
                                this.eat();
                                return Token.ELLIPSIS;
                            }
                            throw this.inputError();
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.floatLiteral();
                        }
                    }
                    return Token.DOT;
                }
                case 39: {
                    char value;
                    this.eat();
                    switch (this.ch) {
                        case 92: {
                            this.eat();
                            value = this.escape();
                            break;
                        }
                        case 39: {
                            throw this.error(TurbineError.ErrorKind.EMPTY_CHARACTER_LITERAL, new Object[0]);
                        }
                        default: {
                            value = (char)this.ch;
                            this.eat();
                        }
                    }
                    if (this.ch == 39) {
                        this.saveValue(String.valueOf(value));
                        this.eat();
                        return Token.CHAR_LITERAL;
                    }
                    throw this.error(TurbineError.ErrorKind.UNTERMINATED_CHARACTER_LITERAL, new Object[0]);
                }
                case 34: {
                    this.eat();
                    if (this.ch == 34) {
                        this.eat();
                        if (this.ch != 34) {
                            this.saveValue("");
                            return Token.STRING_LITERAL;
                        }
                        this.eat();
                        return this.textBlock();
                    }
                    this.readFrom();
                    StringBuilder sb = new StringBuilder();
                    block60: while (true) {
                        switch (this.ch) {
                            case 92: {
                                this.eat();
                                sb.append(this.escape());
                                continue block60;
                            }
                            case 34: {
                                this.saveValue(sb.toString());
                                this.eat();
                                return Token.STRING_LITERAL;
                            }
                            case 10: {
                                throw this.error(TurbineError.ErrorKind.UNTERMINATED_STRING, new Object[0]);
                            }
                            case 26: {
                                if (!this.reader.done()) break;
                                return Token.EOF;
                            }
                        }
                        sb.appendCodePoint(this.ch);
                        this.eat();
                    }
                }
            }
            break;
        }
        if (Character.isJavaIdentifierStart(this.ch)) {
            return this.identifier();
        }
        throw this.inputError();
    }

    private Token textBlock() {
        block11: while (true) {
            switch (this.ch) {
                case 9: 
                case 13: 
                case 32: {
                    this.eat();
                    continue block11;
                }
            }
            break;
        }
        switch (this.ch) {
            case 13: {
                this.eat();
                if (this.ch != 10) break;
                this.eat();
                break;
            }
            case 10: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        this.readFrom();
        StringBuilder sb = new StringBuilder();
        block12: while (true) {
            switch (this.ch) {
                case 34: {
                    this.eat();
                    if (this.ch != 34) {
                        sb.append("\"");
                        continue block12;
                    }
                    this.eat();
                    if (this.ch != 34) {
                        sb.append("\"\"");
                        continue block12;
                    }
                    this.eat();
                    String value = sb.toString();
                    value = StreamLexer.stripIndent(value);
                    value = StreamLexer.translateEscapes(value);
                    this.saveValue(value);
                    return Token.STRING_LITERAL;
                }
                case 26: {
                    if (!this.reader.done()) break;
                    return Token.EOF;
                }
            }
            sb.appendCodePoint(this.ch);
            this.eat();
        }
    }

    static String stripIndent(String value) {
        boolean trailingNewline;
        if (value.isEmpty()) {
            return value;
        }
        ImmutableList lines = value.lines().collect(ImmutableList.toImmutableList());
        int strip = Integer.MAX_VALUE;
        char last = value.charAt(value.length() - 1);
        boolean bl = trailingNewline = last == '\n' || last == '\r';
        if (trailingNewline) {
            strip = 0;
        } else {
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                int nonWhitespaceStart = StreamLexer.nonWhitespaceStart(line);
                if (nonWhitespaceStart == line.length()) continue;
                strip = Math.min(strip, nonWhitespaceStart);
            }
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            int end;
            if (!first) {
                result.append('\n');
            }
            if (strip <= (end = StreamLexer.trailingWhitespaceStart(line))) {
                result.append(line, strip, end);
            }
            first = false;
        }
        if (trailingNewline) {
            result.append('\n');
        }
        return result.toString();
    }

    private static int nonWhitespaceStart(String value) {
        int i;
        for (i = 0; i < value.length() && Character.isWhitespace(value.charAt(i)); ++i) {
        }
        return i;
    }

    private static int trailingWhitespaceStart(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && Character.isWhitespace(value.charAt(i)); --i) {
        }
        return i + 1;
    }

    private static String translateEscapes(String value) {
        StreamLexer lexer = new StreamLexer(new UnicodeEscapePreprocessor(new SourceFile(null, value + '\u001a')));
        return lexer.translateEscapes();
    }

    private String translateEscapes() {
        this.readFrom();
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            switch (this.ch) {
                case 92: {
                    this.eat();
                    sb.append(this.escape());
                    continue block4;
                }
                case 26: {
                    break block4;
                }
                default: {
                    sb.appendCodePoint(this.ch);
                    this.eat();
                    continue block4;
                }
            }
            break;
        }
        return sb.toString();
    }

    private char escape() {
        boolean zeroToThree = false;
        switch (this.ch) {
            case 98: {
                this.eat();
                return '\b';
            }
            case 116: {
                this.eat();
                return '\t';
            }
            case 110: {
                this.eat();
                return '\n';
            }
            case 102: {
                this.eat();
                return '\f';
            }
            case 114: {
                this.eat();
                return '\r';
            }
            case 34: {
                this.eat();
                return '\"';
            }
            case 39: {
                this.eat();
                return '\'';
            }
            case 92: {
                this.eat();
                return '\\';
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                zeroToThree = true;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                char value = (char)(this.ch - 48);
                this.eat();
                switch (this.ch) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        value = (char)(value << 3 | this.ch - 48);
                        this.eat();
                        if (!zeroToThree) break;
                        switch (this.ch) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: {
                                value = (char)(value << 3 | this.ch - 48);
                                this.eat();
                                return value;
                            }
                        }
                        return value;
                    }
                }
                return value;
            }
        }
        throw this.inputError();
    }

    private Token decimalLiteral() {
        this.readDigits();
        switch (this.ch) {
            case 69: 
            case 101: {
                return this.floatLiteral();
            }
            case 46: {
                this.eat();
                return this.floatLiteral();
            }
            case 70: 
            case 102: {
                this.eat();
                return Token.FLOAT_LITERAL;
            }
            case 68: 
            case 100: {
                this.eat();
                return Token.DOUBLE_LITERAL;
            }
            case 76: 
            case 108: {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private Token hexFloatLiteral() {
        this.readHexDigits();
        switch (this.ch) {
            case 80: 
            case 112: {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatLiteral() {
        if (48 <= this.ch && this.ch <= 57) {
            this.readDigits();
        }
        switch (this.ch) {
            case 69: 
            case 101: {
                this.eat();
                this.signedInteger();
                break;
            }
        }
        return this.floatTypeSuffix();
    }

    private Token floatTypeSuffix() {
        switch (this.ch) {
            case 68: 
            case 100: {
                this.eat();
                return Token.DOUBLE_LITERAL;
            }
            case 70: 
            case 102: {
                this.eat();
                return Token.FLOAT_LITERAL;
            }
        }
        return Token.DOUBLE_LITERAL;
    }

    private void signedInteger() {
        switch (this.ch) {
            case 43: 
            case 45: {
                this.eat();
                break;
            }
        }
        this.readDigits();
    }

    private void readHexDigits() {
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private void readDigits() {
        if (48 > this.ch || this.ch > 57) {
            throw this.inputError();
        }
        this.eat();
        block4: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    if (48 <= this.ch && this.ch <= 57) continue block4;
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.eat();
                    continue block4;
                }
            }
            break;
        }
    }

    private Token boolLiteral() {
        this.readBinaryDigits();
        switch (this.ch) {
            case 76: 
            case 108: {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private void readBinaryDigits() {
        switch (this.ch) {
            case 48: 
            case 49: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token octalLiteral() {
        this.readOctalDigits();
        switch (this.ch) {
            case 76: 
            case 108: {
                this.eat();
                return Token.LONG_LITERAL;
            }
        }
        return Token.INT_LITERAL;
    }

    private void readOctalDigits() {
        switch (this.ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 95: {
                this.eat();
                break;
            }
            default: {
                throw this.inputError();
            }
        }
        block10: while (true) {
            switch (this.ch) {
                case 95: {
                    do {
                        this.eat();
                    } while (this.ch == 95);
                    switch (this.ch) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            continue block10;
                        }
                    }
                    throw this.inputError();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    this.eat();
                    continue block10;
                }
            }
            break;
        }
    }

    private Token hexLiteral() {
        this.readHexDigits();
        switch (this.ch) {
            case 46: {
                this.eat();
                return this.hexFloatLiteral();
            }
            case 76: 
            case 108: {
                this.eat();
                return Token.LONG_LITERAL;
            }
            case 80: 
            case 112: {
                this.eat();
                this.signedInteger();
                return this.floatTypeSuffix();
            }
        }
        return Token.INT_LITERAL;
    }

    private Token operator() {
        switch (this.ch) {
            case 61: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.EQ;
                }
                return Token.ASSIGN;
            }
            case 62: {
                this.eat();
                switch (this.ch) {
                    case 61: {
                        this.eat();
                        return Token.GTE;
                    }
                    case 62: {
                        this.eat();
                        switch (this.ch) {
                            case 62: {
                                this.eat();
                                if (this.ch == 61) {
                                    this.eat();
                                    return Token.GTGTGTE;
                                }
                                return Token.GTGTGT;
                            }
                            case 61: {
                                this.eat();
                                return Token.GTGTE;
                            }
                        }
                        return Token.GTGT;
                    }
                }
                return Token.GT;
            }
            case 60: {
                this.eat();
                switch (this.ch) {
                    case 61: {
                        this.eat();
                        return Token.LTE;
                    }
                    case 60: {
                        this.eat();
                        if (this.ch == 61) {
                            this.eat();
                            return Token.LTLTE;
                        }
                        return Token.LTLT;
                    }
                }
                return Token.LT;
            }
            case 33: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.NOTEQ;
                }
                return Token.NOT;
            }
            case 126: {
                this.eat();
                return Token.TILDE;
            }
            case 63: {
                this.eat();
                return Token.COND;
            }
            case 58: {
                this.eat();
                if (this.ch == 58) {
                    this.eat();
                    return Token.COLONCOLON;
                }
                return Token.COLON;
            }
            case 45: {
                this.eat();
                switch (this.ch) {
                    case 62: {
                        this.eat();
                        return Token.ARROW;
                    }
                    case 45: {
                        this.eat();
                        return Token.DECR;
                    }
                    case 61: {
                        this.eat();
                        return Token.MINUSEQ;
                    }
                }
                return Token.MINUS;
            }
            case 38: {
                this.eat();
                switch (this.ch) {
                    case 38: {
                        this.eat();
                        return Token.ANDAND;
                    }
                    case 61: {
                        this.eat();
                        return Token.ANDEQ;
                    }
                }
                return Token.AND;
            }
            case 124: {
                this.eat();
                switch (this.ch) {
                    case 61: {
                        this.eat();
                        return Token.OREQ;
                    }
                    case 124: {
                        this.eat();
                        return Token.OROR;
                    }
                }
                return Token.OR;
            }
            case 43: {
                this.eat();
                switch (this.ch) {
                    case 43: {
                        this.eat();
                        return Token.INCR;
                    }
                    case 61: {
                        this.eat();
                        return Token.PLUSEQ;
                    }
                }
                return Token.PLUS;
            }
            case 42: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.MULTEQ;
                }
                return Token.MULT;
            }
            case 47: {
                throw this.inputError();
            }
            case 37: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.MODEQ;
                }
                return Token.MOD;
            }
            case 94: {
                this.eat();
                if (this.ch == 61) {
                    this.eat();
                    return Token.XOREQ;
                }
                return Token.XOR;
            }
        }
        throw this.inputError();
    }

    private Token identifier() {
        this.readFrom();
        this.eat();
        while (Character.isJavaIdentifierPart(this.ch) && (this.ch != 26 || !this.reader.done())) {
            this.eat();
        }
        return StreamLexer.makeIdent(this.stringValue());
    }

    private static Token makeIdent(String s) {
        switch (s) {
            case "abstract": {
                return Token.ABSTRACT;
            }
            case "assert": {
                return Token.ASSERT;
            }
            case "boolean": {
                return Token.BOOLEAN;
            }
            case "break": {
                return Token.BREAK;
            }
            case "byte": {
                return Token.BYTE;
            }
            case "case": {
                return Token.CASE;
            }
            case "catch": {
                return Token.CATCH;
            }
            case "char": {
                return Token.CHAR;
            }
            case "class": {
                return Token.CLASS;
            }
            case "const": {
                return Token.CONST;
            }
            case "continue": {
                return Token.CONTINUE;
            }
            case "default": {
                return Token.DEFAULT;
            }
            case "do": {
                return Token.DO;
            }
            case "double": {
                return Token.DOUBLE;
            }
            case "else": {
                return Token.ELSE;
            }
            case "enum": {
                return Token.ENUM;
            }
            case "extends": {
                return Token.EXTENDS;
            }
            case "final": {
                return Token.FINAL;
            }
            case "finally": {
                return Token.FINALLY;
            }
            case "float": {
                return Token.FLOAT;
            }
            case "for": {
                return Token.FOR;
            }
            case "goto": {
                return Token.GOTO;
            }
            case "if": {
                return Token.IF;
            }
            case "implements": {
                return Token.IMPLEMENTS;
            }
            case "import": {
                return Token.IMPORT;
            }
            case "instanceof": {
                return Token.INSTANCEOF;
            }
            case "int": {
                return Token.INT;
            }
            case "interface": {
                return Token.INTERFACE;
            }
            case "long": {
                return Token.LONG;
            }
            case "native": {
                return Token.NATIVE;
            }
            case "new": {
                return Token.NEW;
            }
            case "package": {
                return Token.PACKAGE;
            }
            case "private": {
                return Token.PRIVATE;
            }
            case "protected": {
                return Token.PROTECTED;
            }
            case "public": {
                return Token.PUBLIC;
            }
            case "return": {
                return Token.RETURN;
            }
            case "short": {
                return Token.SHORT;
            }
            case "static": {
                return Token.STATIC;
            }
            case "strictfp": {
                return Token.STRICTFP;
            }
            case "super": {
                return Token.SUPER;
            }
            case "switch": {
                return Token.SWITCH;
            }
            case "synchronized": {
                return Token.SYNCHRONIZED;
            }
            case "this": {
                return Token.THIS;
            }
            case "throw": {
                return Token.THROW;
            }
            case "throws": {
                return Token.THROWS;
            }
            case "transient": {
                return Token.TRANSIENT;
            }
            case "try": {
                return Token.TRY;
            }
            case "void": {
                return Token.VOID;
            }
            case "volatile": {
                return Token.VOLATILE;
            }
            case "while": {
                return Token.WHILE;
            }
            case "true": {
                return Token.TRUE;
            }
            case "false": {
                return Token.FALSE;
            }
            case "null": {
                return Token.NULL;
            }
        }
        return Token.IDENT;
    }

    private TurbineError inputError() {
        return this.error(TurbineError.ErrorKind.UNEXPECTED_INPUT, Character.isBmpCodePoint(this.ch) ? Character.toString((char)this.ch) : String.format("U+%X", this.ch));
    }

    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.reader.source(), this.reader.position(), kind, args);
    }
}

