/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.parse.Lexer;
import com.google.turbine.parse.Token;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineOperatorKind;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

public class ConstExpressionParser {
    Token token;
    private int position;
    private final Lexer lexer;

    public ConstExpressionParser(Lexer lexer, Token token, int position) {
        this.lexer = lexer;
        this.token = token;
        this.position = position;
    }

    private static @Nullable TurbineOperatorKind operator(Token token) {
        switch (token) {
            case ASSIGN: {
                return TurbineOperatorKind.ASSIGN;
            }
            case MULT: {
                return TurbineOperatorKind.MULT;
            }
            case DIV: {
                return TurbineOperatorKind.DIVIDE;
            }
            case MOD: {
                return TurbineOperatorKind.MODULO;
            }
            case PLUS: {
                return TurbineOperatorKind.PLUS;
            }
            case MINUS: {
                return TurbineOperatorKind.MINUS;
            }
            case LTLT: {
                return TurbineOperatorKind.SHIFT_LEFT;
            }
            case GTGT: {
                return TurbineOperatorKind.SHIFT_RIGHT;
            }
            case GTGTGT: {
                return TurbineOperatorKind.UNSIGNED_SHIFT_RIGHT;
            }
            case LT: {
                return TurbineOperatorKind.LESS_THAN;
            }
            case GT: {
                return TurbineOperatorKind.GREATER_THAN;
            }
            case LTE: {
                return TurbineOperatorKind.LESS_THAN_EQ;
            }
            case GTE: {
                return TurbineOperatorKind.GREATER_THAN_EQ;
            }
            case EQ: {
                return TurbineOperatorKind.EQUAL;
            }
            case NOTEQ: {
                return TurbineOperatorKind.NOT_EQUAL;
            }
            case AND: {
                return TurbineOperatorKind.BITWISE_AND;
            }
            case OR: {
                return TurbineOperatorKind.BITWISE_OR;
            }
            case XOR: {
                return TurbineOperatorKind.BITWISE_XOR;
            }
            case ANDAND: {
                return TurbineOperatorKind.AND;
            }
            case OROR: {
                return TurbineOperatorKind.OR;
            }
            case COND: {
                return TurbineOperatorKind.TERNARY;
            }
        }
        return null;
    }

    private @Nullable Tree.Expression primary(boolean negate) {
        switch (this.token) {
            case INT_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.INT, negate);
            }
            case DOUBLE_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.DOUBLE, negate);
            }
            case LONG_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.LONG, negate);
            }
            case FLOAT_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.FLOAT, negate);
            }
            case TRUE: {
                int pos = this.position;
                this.eat();
                return new Tree.Literal(pos, TurbineConstantTypeKind.BOOLEAN, new Const.BooleanValue(true));
            }
            case FALSE: {
                int pos = this.position;
                this.eat();
                return new Tree.Literal(pos, TurbineConstantTypeKind.BOOLEAN, new Const.BooleanValue(false));
            }
            case CHAR_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.CHAR, negate);
            }
            case STRING_LITERAL: {
                return this.finishLiteral(TurbineConstantTypeKind.STRING, false);
            }
            case PLUS: {
                this.eat();
                return this.unaryRest(TurbineOperatorKind.UNARY_PLUS);
            }
            case MINUS: {
                this.eat();
                return this.unaryRest(TurbineOperatorKind.NEG);
            }
            case NOT: {
                this.eat();
                return this.unaryRest(TurbineOperatorKind.NOT);
            }
            case TILDE: {
                this.eat();
                return this.unaryRest(TurbineOperatorKind.BITWISE_COMP);
            }
            case LPAREN: {
                return this.maybeCast();
            }
            case LBRACE: {
                int pos = this.position;
                this.eat();
                return this.arrayInitializer(pos);
            }
            case IDENT: {
                return this.qualIdent();
            }
            case BYTE: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.BYTE);
            }
            case CHAR: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.CHAR);
            }
            case DOUBLE: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.DOUBLE);
            }
            case FLOAT: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.FLOAT);
            }
            case INT: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.INT);
            }
            case LONG: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.LONG);
            }
            case SHORT: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.SHORT);
            }
            case BOOLEAN: {
                return this.primitiveClassLiteral(TurbineConstantTypeKind.BOOLEAN);
            }
            case VOID: {
                this.eat();
                return this.finishClassLiteral(this.position, new Tree.VoidTy(this.position));
            }
            case AT: {
                return this.annotation();
            }
        }
        return null;
    }

    private Tree.Expression primitiveClassLiteral(TurbineConstantTypeKind type) {
        this.eat();
        return this.finishClassLiteral(this.position, new Tree.PrimTy(this.position, ImmutableList.of(), type));
    }

    private Tree.Expression maybeCast() {
        this.eat();
        switch (this.token) {
            case BOOLEAN: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.BOOLEAN);
            }
            case BYTE: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.BYTE);
            }
            case SHORT: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.SHORT);
            }
            case INT: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.INT);
            }
            case LONG: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.LONG);
            }
            case CHAR: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.CHAR);
            }
            case DOUBLE: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.DOUBLE);
            }
            case FLOAT: {
                this.eat();
                return this.castTail(TurbineConstantTypeKind.FLOAT);
            }
        }
        return this.notCast();
    }

    private @Nullable Tree.Expression notCast() {
        Tree.Expression expr = this.expression(null);
        if (expr == null) {
            return null;
        }
        if (this.token != Token.RPAREN) {
            return null;
        }
        this.eat();
        if (expr.kind() == Tree.Kind.CONST_VAR_NAME) {
            Tree.ConstVarName cvar = (Tree.ConstVarName)expr;
            switch (this.token) {
                case INT_LITERAL: 
                case FLOAT_LITERAL: 
                case TRUE: 
                case FALSE: 
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case NOT: 
                case TILDE: 
                case IDENT: {
                    Tree.Expression expression = this.primary(false);
                    if (expression == null) {
                        throw this.error(TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
                    }
                    return new Tree.TypeCast(this.position, ConstExpressionParser.asClassTy(cvar.position(), cvar.name()), expression);
                }
            }
            return new Tree.Paren(this.position, expr);
        }
        return new Tree.Paren(this.position, expr);
    }

    private static Tree.ClassTy asClassTy(int pos, ImmutableList<Tree.Ident> names) {
        Tree.ClassTy cty = null;
        for (Tree.Ident bit : names) {
            cty = new Tree.ClassTy(pos, Optional.ofNullable(cty), bit, ImmutableList.of(), ImmutableList.of());
        }
        return cty;
    }

    private void eat() {
        this.token = this.lexer.next();
        this.position = this.lexer.position();
    }

    private @Nullable Tree.Expression arrayInitializer(int pos) {
        if (this.token == Token.RBRACE) {
            this.eat();
            return new Tree.ArrayInit(pos, ImmutableList.of());
        }
        ImmutableList.Builder exprs = ImmutableList.builder();
        block4: while (true) {
            if (this.token == Token.RBRACE) {
                this.eat();
                break;
            }
            Tree.Expression item = this.expression(null);
            if (item == null) {
                return null;
            }
            exprs.add(item);
            switch (this.token) {
                case COMMA: {
                    this.eat();
                    break;
                }
                case RBRACE: {
                    this.eat();
                    break block4;
                }
                default: {
                    return null;
                }
            }
        }
        return new Tree.ArrayInit(pos, (ImmutableList<Tree.Expression>)exprs.build());
    }

    private Tree.Expression finishLiteral(TurbineConstantTypeKind kind, boolean negate) {
        Const.Value value;
        int pos = this.position;
        String text = this.ident().value();
        switch (kind) {
            case INT: {
                int radix = 10;
                if (text.startsWith("0x") || text.startsWith("0X")) {
                    text = text.substring(2);
                    radix = 16;
                } else if (ConstExpressionParser.isOctal(text)) {
                    radix = 8;
                } else if (text.startsWith("0b") || text.startsWith("0B")) {
                    text = text.substring(2);
                    radix = 2;
                }
                if (negate) {
                    text = "-" + text;
                }
                long longValue = this.parseLong(text, radix);
                if (radix == 10 ? longValue != (long)((int)longValue) : Math.abs(longValue) >> 32 != 0L) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
                value = new Const.IntValue((int)longValue);
                break;
            }
            case LONG: {
                int radix = 10;
                if (text.startsWith("0x") || text.startsWith("0X")) {
                    text = text.substring(2);
                    radix = 16;
                } else if (ConstExpressionParser.isOctal(text)) {
                    radix = 8;
                } else if (text.startsWith("0b") || text.startsWith("0B")) {
                    text = text.substring(2);
                    radix = 2;
                }
                if (negate) {
                    text = "-" + text;
                }
                if (text.endsWith("L") || text.endsWith("l")) {
                    text = text.substring(0, text.length() - 1);
                }
                value = new Const.LongValue(this.parseLong(text, radix));
                break;
            }
            case CHAR: {
                value = new Const.CharValue(text.charAt(0));
                break;
            }
            case FLOAT: {
                try {
                    value = new Const.FloatValue(Float.parseFloat(text.replace("_", "")));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
            }
            case DOUBLE: {
                try {
                    value = new Const.DoubleValue(Double.parseDouble(text.replace("_", "")));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
                }
            }
            case STRING: {
                value = new Const.StringValue(text);
                break;
            }
            default: {
                throw new AssertionError((Object)kind);
            }
        }
        this.eat();
        return new Tree.Literal(pos, kind, value);
    }

    static boolean isOctal(String text) {
        if (!text.startsWith("0")) {
            return false;
        }
        if (text.length() <= 1) {
            return false;
        }
        char next = text.charAt(1);
        return Character.isDigit(next) || next == '_';
    }

    private long parseLong(String text, int radix) {
        long r = 0L;
        boolean neg = text.startsWith("-");
        if (neg) {
            text = text.substring(1);
        }
        for (int i = 0; i < text.length(); ++i) {
            int digit;
            char c = text.charAt(i);
            if ('0' <= c && c <= '9') {
                digit = c - 48;
            } else if ('a' <= c && c <= 'f') {
                digit = 10 + (c - 97);
            } else if ('A' <= c && c <= 'F') {
                digit = 10 + (c - 65);
            } else {
                if (c == '_') continue;
                throw this.error(TurbineError.ErrorKind.INVALID_LITERAL, text);
            }
            r = r * (long)radix + (long)digit;
        }
        if (neg) {
            r = -r;
        }
        return r;
    }

    private @Nullable Tree.Expression unaryRest(TurbineOperatorKind op) {
        boolean negate = op == TurbineOperatorKind.NEG;
        Tree.Expression expr = this.primary(negate);
        if (expr == null) {
            return null;
        }
        if (negate && expr.kind() == Tree.Kind.LITERAL) {
            Tree.Literal lit = (Tree.Literal)expr;
            switch (lit.tykind()) {
                case INT: 
                case LONG: {
                    return expr;
                }
            }
        }
        return new Tree.Unary(this.position, expr, op);
    }

    private @Nullable Tree.Expression qualIdent() {
        int pos = this.position;
        ImmutableList.Builder bits = ImmutableList.builder();
        bits.add(this.ident());
        this.eat();
        while (this.token == Token.DOT) {
            this.eat();
            switch (this.token) {
                case IDENT: {
                    bits.add(this.ident());
                    break;
                }
                case CLASS: {
                    this.eat();
                    return new Tree.ClassLiteral(pos, ConstExpressionParser.asClassTy(pos, (ImmutableList<Tree.Ident>)bits.build()));
                }
                default: {
                    return null;
                }
            }
            this.eat();
        }
        if (this.token == Token.LBRACK) {
            return this.finishClassLiteral(pos, ConstExpressionParser.asClassTy(pos, (ImmutableList<Tree.Ident>)bits.build()));
        }
        return new Tree.ConstVarName(pos, (ImmutableList<Tree.Ident>)bits.build());
    }

    private Tree.Ident ident() {
        return new Tree.Ident(this.lexer.position(), this.lexer.stringValue());
    }

    private @Nullable Tree.Expression finishClassLiteral(int pos, Tree.Type type) {
        while (this.token == Token.LBRACK) {
            this.eat();
            if (this.token != Token.RBRACK) {
                return null;
            }
            this.eat();
            type = new Tree.ArrTy(this.position, ImmutableList.of(), type);
        }
        if (this.token != Token.DOT) {
            return null;
        }
        this.eat();
        if (this.token != Token.CLASS) {
            return null;
        }
        this.eat();
        return new Tree.ClassLiteral(pos, type);
    }

    public @Nullable Tree.Expression expression() {
        Tree.Expression result = this.expression(null);
        switch (this.token) {
            case COMMA: 
            case EOF: 
            case SEMI: 
            case RPAREN: {
                return result;
            }
        }
        return null;
    }

    private @Nullable Tree.Expression expression(TurbineOperatorKind.Precedence prec) {
        Tree.Expression term1 = this.primary(false);
        if (term1 == null) {
            return null;
        }
        return this.expression(term1, prec);
    }

    private @Nullable Tree.Expression expression(Tree.Expression term1, TurbineOperatorKind.Precedence prec) {
        do {
            if (this.token == Token.EOF) {
                return term1;
            }
            TurbineOperatorKind op = ConstExpressionParser.operator(this.token);
            if (op == null) {
                return term1;
            }
            if (prec != null && op.prec().rank() <= prec.rank()) {
                return term1;
            }
            this.eat();
            switch (op) {
                case TERNARY: {
                    term1 = this.ternary(term1);
                    break;
                }
                case ASSIGN: {
                    term1 = this.assign(term1, op);
                    break;
                }
                default: {
                    int pos = this.position;
                    Tree.Expression term2 = this.expression(op.prec());
                    if (term2 == null) {
                        return null;
                    }
                    term1 = new Tree.Binary(pos, term1, term2, op);
                }
            }
        } while (term1 != null);
        return null;
    }

    private @Nullable Tree.Expression assign(Tree.Expression term1, TurbineOperatorKind op) {
        if (!(term1 instanceof Tree.ConstVarName)) {
            return null;
        }
        ImmutableList<Tree.Ident> names = ((Tree.ConstVarName)term1).name();
        if (names.size() > 1) {
            return null;
        }
        Tree.Ident name = Iterables.getOnlyElement(names);
        Tree.Expression rhs = this.expression(op.prec());
        if (rhs == null) {
            return null;
        }
        return new Tree.Assign(term1.position(), name, rhs);
    }

    private @Nullable Tree.Expression ternary(Tree.Expression term1) {
        Tree.Expression thenExpr = this.expression(TurbineOperatorKind.Precedence.TERNARY);
        if (thenExpr == null) {
            return null;
        }
        if (this.token != Token.COLON) {
            return null;
        }
        this.eat();
        Tree.Expression elseExpr = this.expression();
        if (elseExpr == null) {
            return null;
        }
        return new Tree.Conditional(this.position, term1, thenExpr, elseExpr);
    }

    private @Nullable Tree.Expression castTail(TurbineConstantTypeKind ty) {
        if (this.token != Token.RPAREN) {
            return null;
        }
        this.eat();
        Tree.Expression rhs = this.primary(false);
        if (rhs == null) {
            return null;
        }
        return new Tree.TypeCast(this.position, new Tree.PrimTy(this.position, ImmutableList.of(), ty), rhs);
    }

    private @Nullable Tree.AnnoExpr annotation() {
        if (this.token != Token.AT) {
            throw new AssertionError();
        }
        this.eat();
        int pos = this.position;
        Tree.Expression constVarName = this.qualIdent();
        if (!(constVarName instanceof Tree.ConstVarName)) {
            return null;
        }
        ImmutableList<Tree.Ident> name = ((Tree.ConstVarName)constVarName).name();
        ImmutableList.Builder args = ImmutableList.builder();
        if (this.token == Token.LPAREN) {
            this.eat();
            while (this.token != Token.RPAREN) {
                int argPos = this.position;
                Tree.Expression expression = this.expression();
                if (expression == null) {
                    throw TurbineError.format(this.lexer.source(), argPos, TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
                }
                args.add(expression);
                if (this.token != Token.COMMA) break;
                this.eat();
            }
            if (this.token == Token.RPAREN) {
                this.eat();
            }
        }
        return new Tree.AnnoExpr(pos, new Tree.Anno(pos, name, (ImmutableList<Tree.Expression>)args.build()));
    }

    @CheckReturnValue
    private TurbineError error(TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.lexer.source(), this.lexer.position(), kind, args);
    }

    public int f() {
        return this.helper(1, 2);
    }

    private int helper(int x, int y) {
        return x + y;
    }
}

