/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import java.util.Objects;

public class LineMap {
    private final String source;
    private final ImmutableRangeMap<Integer, Integer> lines;

    private LineMap(String source, ImmutableRangeMap<Integer, Integer> lines) {
        this.source = source;
        this.lines = lines;
    }

    public static LineMap create(String source) {
        int last = 0;
        int line = 1;
        ImmutableRangeMap.Builder<Integer, Integer> builder = ImmutableRangeMap.builder();
        block4: for (int idx = 0; idx < source.length(); ++idx) {
            char ch = source.charAt(idx);
            switch (ch) {
                case '\r': {
                    if (idx + 1 < source.length() && source.charAt(idx + 1) == '\n') {
                        ++idx;
                    }
                }
                case '\n': {
                    builder.put(Range.closedOpen(last, idx + 1), line++);
                    last = idx + 1;
                    continue block4;
                }
            }
        }
        if (last < source.length()) {
            builder.put(Range.closedOpen(last, source.length()), line++);
        }
        return new LineMap(source, builder.build());
    }

    public int column(int position) {
        Preconditions.checkArgument(0 <= position && position < this.source.length(), "%s", position);
        return position - Objects.requireNonNull(this.lines.getEntry(position)).getKey().lowerEndpoint();
    }

    public int lineNumber(int position) {
        Preconditions.checkArgument(0 <= position && position < this.source.length(), "%s", position);
        return Objects.requireNonNull(this.lines.get(position));
    }

    public String line(int position) {
        Preconditions.checkArgument(0 <= position && position < this.source.length(), "%s", position);
        Range<Integer> range = Objects.requireNonNull(this.lines.getEntry(position)).getKey();
        return this.source.substring(range.lowerEndpoint(), range.upperEndpoint());
    }
}

