/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineElementType;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.nullness.Nullable;

public class BytecodeBoundClass
implements TypeBoundClass {
    private final ClassSymbol sym;
    private final Env<ClassSymbol, BytecodeBoundClass> env;
    private final Supplier<ClassFile> classFile;
    private final @Nullable String jarFile;
    private final Supplier<TurbineTyKind> kind = Suppliers.memoize(new Supplier<TurbineTyKind>(){

        @Override
        public TurbineTyKind get() {
            int access = BytecodeBoundClass.this.access();
            if ((access & 0x2000) == 8192) {
                return TurbineTyKind.ANNOTATION;
            }
            if ((access & 0x200) == 512) {
                return TurbineTyKind.INTERFACE;
            }
            if ((access & 0x4000) == 16384) {
                return TurbineTyKind.ENUM;
            }
            return TurbineTyKind.CLASS;
        }
    });
    private final Supplier<@Nullable ClassSymbol> owner = Suppliers.memoize(new Supplier<ClassSymbol>(){

        @Override
        public @Nullable ClassSymbol get() {
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                return new ClassSymbol(inner.outerClass());
            }
            return null;
        }
    });
    private final Supplier<ImmutableMap<String, ClassSymbol>> children = Suppliers.memoize(new Supplier<ImmutableMap<String, ClassSymbol>>(){

        @Override
        public ImmutableMap<String, ClassSymbol> get() {
            ImmutableMap.Builder<String, ClassSymbol> result = ImmutableMap.builder();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (inner.innerName() == null || !BytecodeBoundClass.this.sym.binaryName().equals(inner.outerClass())) continue;
                result.put(inner.innerName(), new ClassSymbol(inner.innerClass()));
            }
            return result.buildOrThrow();
        }
    });
    private final Supplier<Integer> access = Suppliers.memoize(new Supplier<Integer>(){

        @Override
        public Integer get() {
            int access = ((ClassFile)BytecodeBoundClass.this.classFile.get()).access();
            for (ClassFile.InnerClass inner : ((ClassFile)BytecodeBoundClass.this.classFile.get()).innerClasses()) {
                if (!BytecodeBoundClass.this.sym.binaryName().equals(inner.innerClass())) continue;
                access = inner.access();
            }
            return access;
        }
    });
    private final Supplier< @Nullable Sig.ClassSig> sig = Suppliers.memoize(new Supplier<Sig.ClassSig>(){

        @Override
        public  @Nullable Sig.ClassSig get() {
            String signature = ((ClassFile)BytecodeBoundClass.this.classFile.get()).signature();
            if (signature == null) {
                return null;
            }
            return new SigParser(signature).parseClassSig();
        }
    });
    private final Supplier<ImmutableMap<String, TyVarSymbol>> tyParams = Suppliers.memoize(new Supplier<ImmutableMap<String, TyVarSymbol>>(){

        @Override
        public ImmutableMap<String, TyVarSymbol> get() {
            Sig.ClassSig csig = (Sig.ClassSig)BytecodeBoundClass.this.sig.get();
            if (csig == null || csig.tyParams().isEmpty()) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder<String, TyVarSymbol> result = ImmutableMap.builder();
            for (Sig.TyParamSig p : csig.tyParams()) {
                result.put(p.name(), new TyVarSymbol(BytecodeBoundClass.this.sym, p.name()));
            }
            return result.buildOrThrow();
        }
    });
    private final Supplier<@Nullable ClassSymbol> superclass = Suppliers.memoize(new Supplier<ClassSymbol>(){

        @Override
        public @Nullable ClassSymbol get() {
            String superclass = ((ClassFile)BytecodeBoundClass.this.classFile.get()).superName();
            if (superclass == null) {
                return null;
            }
            return new ClassSymbol(superclass);
        }
    });
    private final Supplier<ImmutableList<ClassSymbol>> interfaces = Suppliers.memoize(new Supplier<ImmutableList<ClassSymbol>>(){

        @Override
        public ImmutableList<ClassSymbol> get() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String i : ((ClassFile)BytecodeBoundClass.this.classFile.get()).interfaces()) {
                result.add(new ClassSymbol(i));
            }
            return result.build();
        }
    });
    private final Supplier<@Nullable Type.ClassTy> superClassType = Suppliers.memoize(new Supplier<Type.ClassTy>(){

        @Override
        public @Nullable Type.ClassTy get() {
            if (BytecodeBoundClass.this.superclass() == null) {
                return null;
            }
            if (BytecodeBoundClass.this.sig.get() == null || ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass() == null) {
                return Type.ClassTy.asNonParametricClassTy(BytecodeBoundClass.this.superclass());
            }
            return BytecodeBinder.bindClassTy(((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).superClass(), BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, ImmutableMap.of()));
        }
    });
    private final Supplier<ImmutableList<Type>> interfaceTypes = Suppliers.memoize(new Supplier<ImmutableList<Type>>(){

        @Override
        public ImmutableList<Type> get() {
            if (BytecodeBoundClass.this.interfaces().isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder result = ImmutableList.builder();
            if (BytecodeBoundClass.this.sig.get() == null || ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).interfaces() == null) {
                for (ClassSymbol sym : BytecodeBoundClass.this.interfaces()) {
                    result.add(Type.ClassTy.asNonParametricClassTy(sym));
                }
            } else {
                Function scope = BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, ImmutableMap.of());
                for (Sig.ClassTySig classTySig : ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).interfaces()) {
                    result.add(BytecodeBinder.bindClassTy(classTySig, scope));
                }
            }
            return result.build();
        }
    });
    private final Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>> typeParameterTypes = Suppliers.memoize(new Supplier<ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>>(){

        @Override
        public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> get() {
            if (BytecodeBoundClass.this.sig.get() == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder<TyVarSymbol, TypeBoundClass.TyVarInfo> tparams = ImmutableMap.builder();
            Function scope = BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, BytecodeBoundClass.this.typeParameters());
            for (Sig.TyParamSig p : ((Sig.ClassSig)BytecodeBoundClass.this.sig.get()).tyParams()) {
                tparams.put(Objects.requireNonNull(BytecodeBoundClass.this.typeParameters().get(p.name())), BytecodeBoundClass.bindTyParam(p, scope));
            }
            return tparams.buildOrThrow();
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.FieldInfo>> fields = Suppliers.memoize(new Supplier<ImmutableList<TypeBoundClass.FieldInfo>>(){

        @Override
        public ImmutableList<TypeBoundClass.FieldInfo> get() {
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ClassFile.FieldInfo cfi : ((ClassFile)BytecodeBoundClass.this.classFile.get()).fields()) {
                FieldSymbol fieldSym = new FieldSymbol(BytecodeBoundClass.this.sym, cfi.name());
                Type type = BytecodeBinder.bindTy(new SigParser(MoreObjects.firstNonNull(cfi.signature(), cfi.descriptor())).parseType(), BytecodeBoundClass.makeScope(BytecodeBoundClass.this.env, BytecodeBoundClass.this.sym, ImmutableMap.of()));
                int access = cfi.access();
                Const.Value value = cfi.value();
                if (value != null) {
                    value = BytecodeBinder.bindConstValue(type, value);
                }
                ImmutableList<AnnoInfo> annotations = BytecodeBinder.bindAnnotations(cfi.annotations());
                fields.add(new TypeBoundClass.FieldInfo(fieldSym, type, access, annotations, null, value));
            }
            return fields.build();
        }
    });
    private final Supplier<ImmutableList<TypeBoundClass.MethodInfo>> methods = Suppliers.memoize(new Supplier<ImmutableList<TypeBoundClass.MethodInfo>>(){

        @Override
        public ImmutableList<TypeBoundClass.MethodInfo> get() {
            ImmutableList.Builder methods = ImmutableList.builder();
            int idx = 0;
            ClassFile cf = (ClassFile)BytecodeBoundClass.this.classFile.get();
            for (ClassFile.MethodInfo m : cf.methods()) {
                if (m.name().equals("<clinit>")) continue;
                methods.add(BytecodeBoundClass.this.bindMethod(cf, idx++, m));
            }
            return methods.build();
        }
    });
    private final Supplier<@Nullable AnnotationMetadata> annotationMetadata = Suppliers.memoize(new Supplier<AnnotationMetadata>(){

        @Override
        public @Nullable AnnotationMetadata get() {
            if ((BytecodeBoundClass.this.access() & 0x2000) != 8192) {
                return null;
            }
            RetentionPolicy retention = null;
            ImmutableSet target = null;
            ClassSymbol repeatable = null;
            for (ClassFile.AnnotationInfo annotation : ((ClassFile)BytecodeBoundClass.this.classFile.get()).annotations()) {
                switch (annotation.typeName()) {
                    case "Ljava/lang/annotation/Retention;": {
                        retention = BytecodeBoundClass.bindRetention(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Target;": {
                        target = BytecodeBoundClass.bindTarget(annotation);
                        break;
                    }
                    case "Ljava/lang/annotation/Repeatable;": {
                        repeatable = BytecodeBoundClass.bindRepeatable(annotation);
                        break;
                    }
                }
            }
            return new AnnotationMetadata(retention, target, repeatable);
        }
    });
    private final Supplier<ImmutableList<AnnoInfo>> annotations = Suppliers.memoize(new Supplier<ImmutableList<AnnoInfo>>(){

        @Override
        public ImmutableList<AnnoInfo> get() {
            return BytecodeBinder.bindAnnotations(((ClassFile)BytecodeBoundClass.this.classFile.get()).annotations());
        }
    });

    public BytecodeBoundClass(final ClassSymbol sym, final Supplier<byte[]> bytes, Env<ClassSymbol, BytecodeBoundClass> env, final @Nullable String jarFile) {
        this.sym = sym;
        this.env = env;
        this.jarFile = jarFile;
        this.classFile = Suppliers.memoize(new Supplier<ClassFile>(){

            @Override
            public ClassFile get() {
                ClassFile cf = ClassReader.read(jarFile + "!" + sym.binaryName(), (byte[])bytes.get());
                Verify.verify(cf.name().equals(sym.binaryName()), "expected class data for %s, saw %s instead", (Object)sym.binaryName(), (Object)cf.name());
                return cf;
            }
        });
    }

    @Override
    public TurbineTyKind kind() {
        return this.kind.get();
    }

    @Override
    public @Nullable ClassSymbol owner() {
        return this.owner.get();
    }

    @Override
    public ImmutableMap<String, ClassSymbol> children() {
        return this.children.get();
    }

    @Override
    public int access() {
        return this.access.get();
    }

    @Override
    public ImmutableMap<String, TyVarSymbol> typeParameters() {
        return this.tyParams.get();
    }

    @Override
    public @Nullable ClassSymbol superclass() {
        return this.superclass.get();
    }

    @Override
    public ImmutableList<ClassSymbol> interfaces() {
        return this.interfaces.get();
    }

    @Override
    public @Nullable Type.ClassTy superClassType() {
        return this.superClassType.get();
    }

    @Override
    public ImmutableList<Type> interfaceTypes() {
        return this.interfaceTypes.get();
    }

    @Override
    public ImmutableList<ClassSymbol> permits() {
        return ImmutableList.of();
    }

    private static TypeBoundClass.TyVarInfo bindTyParam(Sig.TyParamSig sig, Function<String, TyVarSymbol> scope) {
        ImmutableList.Builder bounds = ImmutableList.builder();
        if (sig.classBound() != null) {
            bounds.add(BytecodeBinder.bindTy(sig.classBound(), scope));
        }
        for (Sig.TySig t : sig.interfaceBounds()) {
            bounds.add(BytecodeBinder.bindTy(t, scope));
        }
        return new TypeBoundClass.TyVarInfo(Type.IntersectionTy.create((ImmutableList<Type>)bounds.build()), null, ImmutableList.of());
    }

    @Override
    public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes() {
        return this.typeParameterTypes.get();
    }

    @Override
    public ImmutableList<TypeBoundClass.FieldInfo> fields() {
        return this.fields.get();
    }

    /*
     * WARNING - void declaration
     */
    private TypeBoundClass.MethodInfo bindMethod(ClassFile classFile, int methodIdx, ClassFile.MethodInfo m) {
        int access;
        MethodSymbol methodSymbol = new MethodSymbol(methodIdx, this.sym, m.name());
        Sig.MethodSig sig = new SigParser(MoreObjects.firstNonNull(m.signature(), m.descriptor())).parseMethodSig();
        ImmutableMap.Builder<String, TyVarSymbol> result = ImmutableMap.builder();
        for (Sig.TyParamSig p : sig.tyParams()) {
            result.put(p.name(), new TyVarSymbol(methodSymbol, p.name()));
        }
        ImmutableMap<String, TyVarSymbol> tyParams = result.buildOrThrow();
        ImmutableMap.Builder<TyVarSymbol, TypeBoundClass.TyVarInfo> tparams = ImmutableMap.builder();
        Function<String, TyVarSymbol> scope = BytecodeBoundClass.makeScope(this.env, this.sym, tyParams);
        for (Sig.TyParamSig p : sig.tyParams()) {
            tparams.put(Objects.requireNonNull(tyParams.get(p.name())), BytecodeBoundClass.bindTyParam(p, scope));
        }
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> tyParamTypes = tparams.buildOrThrow();
        Function<String, TyVarSymbol> scope2 = BytecodeBoundClass.makeScope(this.env, this.sym, tyParams);
        Type ret = BytecodeBinder.bindTy(sig.returnType(), scope2);
        ImmutableList.Builder formals = ImmutableList.builder();
        int idx = 0;
        for (Sig.TySig tySig : sig.params()) {
            void var14_19;
            access = 0;
            if (idx < m.parameters().size()) {
                ClassFile.MethodInfo.ParameterInfo paramInfo = (ClassFile.MethodInfo.ParameterInfo)m.parameters().get(idx);
                String string = paramInfo.name();
            } else {
                String string = "arg" + idx;
            }
            ImmutableList<AnnoInfo> annotations = idx < m.parameterAnnotations().size() ? BytecodeBinder.bindAnnotations((List)m.parameterAnnotations().get(idx)) : ImmutableList.of();
            formals.add(new TypeBoundClass.ParamInfo(new ParamSymbol(methodSymbol, (String)var14_19), BytecodeBinder.bindTy(tySig, scope2), annotations, access));
            ++idx;
        }
        ImmutableList.Builder exceptions = ImmutableList.builder();
        if (!sig.exceptions().isEmpty()) {
            for (Sig.TySig tySig : sig.exceptions()) {
                exceptions.add(BytecodeBinder.bindTy(tySig, scope2));
            }
        } else {
            for (String string : m.exceptions()) {
                exceptions.add(Type.ClassTy.asNonParametricClassTy(new ClassSymbol(string)));
            }
        }
        Const const_ = m.defaultValue() != null ? BytecodeBinder.bindValue(m.defaultValue()) : null;
        ImmutableList<AnnoInfo> immutableList = BytecodeBinder.bindAnnotations(m.annotations());
        access = m.access();
        if ((classFile.access() & 0x200) == 512 && (access & 0x408) == 0) {
            access |= 0x10000;
        }
        return new TypeBoundClass.MethodInfo(methodSymbol, tyParamTypes, ret, (ImmutableList<TypeBoundClass.ParamInfo>)formals.build(), (ImmutableList<Type>)exceptions.build(), access, const_, null, immutableList, null);
    }

    @Override
    public ImmutableList<TypeBoundClass.MethodInfo> methods() {
        return this.methods.get();
    }

    @Override
    public ImmutableList<TypeBoundClass.RecordComponentInfo> components() {
        return ImmutableList.of();
    }

    private static @Nullable RetentionPolicy bindRetention(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        if (val == null) {
            return null;
        }
        if (val.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) {
            return null;
        }
        ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal = (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val;
        if (!enumVal.typeName().equals("Ljava/lang/annotation/RetentionPolicy;")) {
            return null;
        }
        return RetentionPolicy.valueOf(enumVal.constName());
    }

    private static ImmutableSet<TurbineElementType> bindTarget(ClassFile.AnnotationInfo annotation) {
        ImmutableSet.Builder<TurbineElementType> result = ImmutableSet.builder();
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        Objects.requireNonNull(val);
        switch (val.kind()) {
            case ARRAY: {
                for (ClassFile.AnnotationInfo.ElementValue element : ((ClassFile.AnnotationInfo.ElementValue.ArrayValue)val).elements()) {
                    if (element.kind() != ClassFile.AnnotationInfo.ElementValue.Kind.ENUM) continue;
                    BytecodeBoundClass.bindTargetElement(result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)element);
                }
                break;
            }
            case ENUM: {
                BytecodeBoundClass.bindTargetElement(result, (ClassFile.AnnotationInfo.ElementValue.EnumConstValue)val);
                break;
            }
        }
        return result.build();
    }

    private static void bindTargetElement(ImmutableSet.Builder<TurbineElementType> target, ClassFile.AnnotationInfo.ElementValue.EnumConstValue enumVal) {
        if (enumVal.typeName().equals("Ljava/lang/annotation/ElementType;")) {
            target.add((Object)TurbineElementType.valueOf(enumVal.constName()));
        }
    }

    private static @Nullable ClassSymbol bindRepeatable(ClassFile.AnnotationInfo annotation) {
        ClassFile.AnnotationInfo.ElementValue val = annotation.elementValuePairs().get("value");
        if (val == null) {
            return null;
        }
        switch (val.kind()) {
            case CLASS: {
                String className = ((ClassFile.AnnotationInfo.ElementValue.ConstTurbineClassValue)val).className();
                return new ClassSymbol(className.substring(1, className.length() - 1));
            }
        }
        return null;
    }

    @Override
    public @Nullable AnnotationMetadata annotationMetadata() {
        return this.annotationMetadata.get();
    }

    @Override
    public ImmutableList<AnnoInfo> annotations() {
        return this.annotations.get();
    }

    private static Function<String, TyVarSymbol> makeScope(final Env<ClassSymbol, BytecodeBoundClass> env, final ClassSymbol sym, final Map<String, TyVarSymbol> typeVariables) {
        return new Function<String, TyVarSymbol>(){

            @Override
            public TyVarSymbol apply(String input) {
                TyVarSymbol result = (TyVarSymbol)typeVariables.get(input);
                if (result != null) {
                    return result;
                }
                ClassSymbol curr = sym;
                while (curr != null) {
                    BytecodeBoundClass info = (BytecodeBoundClass)env.get(curr);
                    if (info == null) {
                        throw new AssertionError(curr);
                    }
                    result = info.typeParameters().get(input);
                    if (result != null) {
                        return result;
                    }
                    curr = info.owner();
                }
                throw new AssertionError((Object)input);
            }
        };
    }

    public @Nullable String jarFile() {
        String transitiveJar = this.classFile.get().transitiveJar();
        if (transitiveJar != null) {
            return transitiveJar;
        }
        return this.jarFile;
    }

    public ClassFile classFile() {
        return this.classFile.get();
    }
}

