/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.turbine.binder.AutoValue_Processing_ProcessorInfo;
import com.google.turbine.binder.AutoValue_Processing_SupportedAnnotationTypes;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.parse.Parser;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineElements;
import com.google.turbine.processing.TurbineFiler;
import com.google.turbine.processing.TurbineMessager;
import com.google.turbine.processing.TurbineProcessingEnvironment;
import com.google.turbine.processing.TurbineRoundEnvironment;
import com.google.turbine.processing.TurbineTypes;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import org.jspecify.nullness.Nullable;

public class Processing {
    static @Nullable Binder.BindingResult process(TurbineLog log, ImmutableList<Tree.CompUnit> initialSources, final ClassPath classpath, ProcessorInfo processorInfo, ClassPath bootclasspath, Binder.BindingResult result, Optional<String> moduleVersion) {
        HashSet<String> seen = new HashSet<String>();
        for (Tree.CompUnit u : initialSources) {
            if (u.source() == null) continue;
            seen.add(u.source().path());
        }
        TurbineFiler filer = new TurbineFiler(seen, new Function<String, Supplier<byte[]>>(){

            @Override
            public @Nullable Supplier<byte[]> apply(String input) {
                return classpath.resource(input);
            }
        }, processorInfo.loader());
        SimpleEnv<ClassSymbol, SourceTypeBoundClass> tenv = new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(result.units());
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(result.classPathEnv()).append(tenv);
        ModelFactory factory = new ModelFactory(env, processorInfo.loader(), result.tli());
        LinkedHashMap<String, byte[]> statistics = new LinkedHashMap<String, byte[]>();
        TurbineTypes turbineTypes = new TurbineTypes(factory);
        TurbineProcessingEnvironment processingEnv = new TurbineProcessingEnvironment(filer, turbineTypes, new TurbineElements(factory, turbineTypes), new TurbineMessager(factory, log), processorInfo.options(), processorInfo.sourceVersion(), processorInfo.loader(), statistics);
        Timers timers = new Timers();
        for (Processor processor : processorInfo.processors()) {
            try {
                Timers.Timer unused = timers.start(processor);
                try {
                    processor.init(processingEnv);
                }
                finally {
                    if (unused == null) continue;
                    unused.close();
                }
            }
            catch (Throwable t) {
                Processing.logProcessorCrash(log, processor, t);
                return null;
            }
        }
        ImmutableMap<Processor, SupportedAnnotationTypes> wanted = Processing.initializeSupportedAnnotationTypes(processorInfo);
        HashSet<ClassSymbol> allSymbols = new HashSet<ClassSymbol>();
        ImmutableCollection.Builder units = ImmutableList.builder().addAll(initialSources);
        LinkedHashSet<Processor> toRun = new LinkedHashSet<Processor>();
        boolean errorRaised = false;
        while (true) {
            ImmutableSet<ClassSymbol> syms = Sets.difference(result.units().keySet(), allSymbols).immutableCopy();
            allSymbols.addAll(syms);
            if (syms.isEmpty()) break;
            ImmutableSetMultimap<ClassSymbol, Symbol> allAnnotations = Processing.getAllAnnotations(env, syms);
            TurbineRoundEnvironment roundEnv = null;
            for (Map.Entry e : wanted.entrySet()) {
                Processor processor = (Processor)e.getKey();
                SupportedAnnotationTypes supportedAnnotationTypes = (SupportedAnnotationTypes)e.getValue();
                HashSet<TurbineElement.TurbineTypeElement> annotations = new HashSet<TurbineElement.TurbineTypeElement>();
                boolean run = supportedAnnotationTypes.everything() || toRun.contains(processor);
                for (ClassSymbol a : allAnnotations.keys()) {
                    if (!supportedAnnotationTypes.everything() && !supportedAnnotationTypes.pattern().matcher(a.toString()).matches()) continue;
                    annotations.add(factory.typeElement(a));
                    run = true;
                }
                if (!run) continue;
                toRun.add(processor);
                if (roundEnv == null) {
                    roundEnv = new TurbineRoundEnvironment(factory, syms, false, errorRaised, allAnnotations);
                }
                try {
                    Timers.Timer unused = timers.start(processor);
                    try {
                        processor.process(annotations, roundEnv);
                    }
                    finally {
                        if (unused == null) continue;
                        unused.close();
                    }
                }
                catch (Throwable t) {
                    Processing.logProcessorCrash(log, processor, t);
                    return null;
                }
            }
            Collection<SourceFile> files = filer.finishRound();
            if (files.isEmpty()) break;
            for (SourceFile file : files) {
                ((ImmutableList.Builder)units).add(Parser.parse(file));
            }
            errorRaised = log.errorRaised();
            if (errorRaised) break;
            log.clear();
            result = Binder.bind(log, (ImmutableList<Tree.CompUnit>)((ImmutableList.Builder)units).build(), filer.generatedSources(), filer.generatedClasses(), classpath, bootclasspath, moduleVersion);
            tenv = new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(result.units());
            env = CompoundEnv.of(result.classPathEnv()).append(tenv);
            factory.round(env, result.tli());
        }
        TurbineRoundEnvironment roundEnv = null;
        for (Processor processor : toRun) {
            if (roundEnv == null) {
                roundEnv = new TurbineRoundEnvironment(factory, ImmutableSet.of(), true, errorRaised, ImmutableSetMultimap.of());
            }
            try {
                Timers.Timer unused = timers.start(processor);
                try {
                    processor.process(ImmutableSet.of(), roundEnv);
                }
                finally {
                    if (unused == null) continue;
                    unused.close();
                }
            }
            catch (Throwable t) {
                Processing.logProcessorCrash(log, processor, t);
                return null;
            }
        }
        Collection<SourceFile> files = filer.finishRound();
        if (!files.isEmpty()) {
            for (SourceFile file : files) {
                ((ImmutableList.Builder)units).add(Parser.parse(file));
            }
            result = Binder.bind(log, (ImmutableList<Tree.CompUnit>)((ImmutableList.Builder)units).build(), filer.generatedSources(), filer.generatedClasses(), classpath, bootclasspath, moduleVersion);
            if (log.anyErrors()) {
                return null;
            }
        }
        if (!filer.generatedClasses().isEmpty()) {
            result = result.withGeneratedClasses(filer.generatedClasses());
        }
        if (!filer.generatedSources().isEmpty()) {
            result = result.withGeneratedSources(filer.generatedSources());
        }
        result = result.withStatistics(Binder.Statistics.create(timers.build(), ImmutableMap.copyOf(statistics)));
        return result;
    }

    private static ImmutableMap<Processor, SupportedAnnotationTypes> initializeSupportedAnnotationTypes(ProcessorInfo processorInfo) {
        ImmutableMap.Builder<Processor, SupportedAnnotationTypes> result = ImmutableMap.builder();
        for (Processor processor : processorInfo.processors()) {
            result.put(processor, SupportedAnnotationTypes.create(processor));
        }
        return result.buildOrThrow();
    }

    private static void logProcessorCrash(TurbineLog log, Processor processor, Throwable t) {
        log.diagnostic(Diagnostic.Kind.ERROR, String.format("An exception occurred in %s:\n%s", processor.getClass().getCanonicalName(), Throwables.getStackTraceAsString(t)));
    }

    private static ImmutableSetMultimap<ClassSymbol, Symbol> getAllAnnotations(Env<ClassSymbol, TypeBoundClass> env, Iterable<ClassSymbol> syms) {
        ImmutableSetMultimap.Builder<ClassSymbol, Symbol> result = ImmutableSetMultimap.builder();
        for (ClassSymbol sym : syms) {
            TypeBoundClass info = env.getNonNull(sym);
            for (AnnoInfo annoInfo : info.annotations()) {
                if (sym.simpleName().equals("package-info")) {
                    Processing.addAnno(result, annoInfo, sym.owner());
                    continue;
                }
                Processing.addAnno(result, annoInfo, sym);
            }
            for (ClassSymbol inheritedAnno : Processing.inheritedAnnotations(new HashSet<ClassSymbol>(), info.superclass(), env)) {
                result.put((Object)inheritedAnno, (Object)sym);
            }
            for (TypeBoundClass.MethodInfo method : info.methods()) {
                for (AnnoInfo annoInfo : method.annotations()) {
                    Processing.addAnno(result, annoInfo, method.sym());
                }
                for (TypeBoundClass.ParamInfo param : method.parameters()) {
                    for (AnnoInfo annoInfo : param.annotations()) {
                        Processing.addAnno(result, annoInfo, param.sym());
                    }
                }
            }
            for (TypeBoundClass.FieldInfo field : info.fields()) {
                for (AnnoInfo annoInfo : field.annotations()) {
                    Processing.addAnno(result, annoInfo, field.sym());
                }
            }
        }
        return result.build();
    }

    private static ImmutableSet<ClassSymbol> inheritedAnnotations(Set<ClassSymbol> seen, @Nullable ClassSymbol sym, Env<ClassSymbol, TypeBoundClass> env) {
        TypeBoundClass info;
        ImmutableSet.Builder result = ImmutableSet.builder();
        ClassSymbol curr = sym;
        while (curr != null && seen.add(curr) && (info = env.get(curr)) != null) {
            for (AnnoInfo anno : info.annotations()) {
                ClassSymbol annoSym = anno.sym();
                if (annoSym == null || !Processing.isAnnotationInherited(env, annoSym)) continue;
                result.add(annoSym);
            }
            curr = info.superclass();
        }
        return result.build();
    }

    private static boolean isAnnotationInherited(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        TypeBoundClass annoInfo = env.get(sym);
        if (annoInfo == null) {
            return false;
        }
        for (AnnoInfo anno : annoInfo.annotations()) {
            if (!Objects.equals(anno.sym(), ClassSymbol.INHERITED)) continue;
            return true;
        }
        return false;
    }

    private static void addAnno(ImmutableSetMultimap.Builder<ClassSymbol, Symbol> result, AnnoInfo annoInfo, Symbol owner) {
        ClassSymbol sym = annoInfo.sym();
        if (sym != null) {
            result.put((Object)sym, (Object)owner);
        }
    }

    public static ProcessorInfo initializeProcessors(SourceVersion sourceVersion, ImmutableList<String> javacopts, ImmutableSet<String> processorNames, ClassLoader processorLoader) {
        if (processorNames.isEmpty() || javacopts.contains("-proc:none")) {
            return ProcessorInfo.empty();
        }
        ImmutableList<Processor> processors = Processing.instantiateProcessors(processorNames, processorLoader);
        ImmutableMap<String, String> processorOptions = Processing.processorOptions(javacopts);
        return ProcessorInfo.create(processors, processorLoader, processorOptions, sourceVersion);
    }

    private static ImmutableList<Processor> instantiateProcessors(ImmutableSet<String> processorNames, ClassLoader processorLoader) {
        ImmutableList.Builder processors = ImmutableList.builder();
        for (String processor : processorNames) {
            try {
                Class<Processor> clazz = Class.forName(processor, false, processorLoader).asSubclass(Processor.class);
                processors.add(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
        return processors.build();
    }

    public static ClassLoader processorLoader(ImmutableList<String> processorPath, final ImmutableSet<String> builtinProcessors) throws MalformedURLException {
        if (processorPath.isEmpty()) {
            return Processing.class.getClassLoader();
        }
        return new URLClassLoader(Processing.toUrls(processorPath), new ClassLoader(ClassLoader.getPlatformClassLoader()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.equals("com.google.turbine.processing.TurbineProcessingEnvironment")) {
                    return Class.forName(name);
                }
                if (!builtinProcessors.isEmpty() && (name.startsWith("com.sun.source.") || name.startsWith("com.sun.tools.") || name.startsWith("com.google.common.collect.") || name.startsWith("com.google.common.base.") || name.startsWith("com.google.common.graph.") || name.startsWith("com.google.devtools.build.buildjar.javac.statistics.") || name.startsWith("dagger.model.") || name.startsWith("dagger.spi.") || builtinProcessors.contains(name))) {
                    return Class.forName(name);
                }
                throw new ClassNotFoundException(name);
            }
        });
    }

    private static URL[] toUrls(ImmutableList<String> processorPath) throws MalformedURLException {
        URL[] urls = new URL[processorPath.size()];
        int i = 0;
        for (String path : processorPath) {
            urls[i++] = Paths.get(path, new String[0]).toUri().toURL();
        }
        return urls;
    }

    private static ImmutableMap<String, String> processorOptions(ImmutableList<String> javacopts) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String javacopt : javacopts) {
            String value;
            String key;
            if (!javacopt.startsWith("-A")) continue;
            int idx = (javacopt = javacopt.substring("-A".length())).indexOf(61);
            if (idx != -1) {
                key = javacopt.substring(0, idx);
                value = javacopt.substring(idx + 1);
            } else {
                key = javacopt;
                value = javacopt;
            }
            result.put(key, value);
        }
        return ImmutableMap.copyOf(result);
    }

    private Processing() {
    }

    private static class Timers {
        private final Map<Class<?>, Stopwatch> processorTimers = new LinkedHashMap();

        private Timers() {
        }

        Timer start(Processor processor) {
            Class<?> clazz = processor.getClass();
            Stopwatch sw = this.processorTimers.get(clazz);
            if (sw == null) {
                sw = Stopwatch.createUnstarted();
                this.processorTimers.put(clazz, sw);
            }
            sw.start();
            return new Timer(sw);
        }

        ImmutableMap<String, Duration> build() {
            ImmutableMap.Builder<String, Duration> result = ImmutableMap.builder();
            for (Map.Entry<Class<?>, Stopwatch> e : this.processorTimers.entrySet()) {
                result.put(Objects.requireNonNull(e.getKey().getCanonicalName()), e.getValue().elapsed());
            }
            return result.buildOrThrow();
        }

        private static class Timer
        implements AutoCloseable {
            private final Stopwatch sw;

            public Timer(Stopwatch sw) {
                this.sw = sw;
            }

            @Override
            public void close() {
                this.sw.stop();
            }
        }
    }

    @AutoValue
    public static abstract class ProcessorInfo {
        abstract ImmutableList<Processor> processors();

        abstract @Nullable ClassLoader loader();

        abstract ImmutableMap<String, String> options();

        public abstract SourceVersion sourceVersion();

        public static ProcessorInfo create(ImmutableList<Processor> processors, @Nullable ClassLoader loader, ImmutableMap<String, String> options, SourceVersion sourceVersion) {
            return new AutoValue_Processing_ProcessorInfo(processors, loader, options, sourceVersion);
        }

        static ProcessorInfo empty() {
            return ProcessorInfo.create(ImmutableList.of(), null, ImmutableMap.of(), SourceVersion.latest());
        }
    }

    @AutoValue
    static abstract class SupportedAnnotationTypes {
        SupportedAnnotationTypes() {
        }

        abstract boolean everything();

        abstract Pattern pattern();

        static SupportedAnnotationTypes create(Processor processor) {
            ArrayList<String> patterns = new ArrayList<String>();
            boolean everything = false;
            for (String supportedAnnotationType : processor.getSupportedAnnotationTypes()) {
                if (supportedAnnotationType.equals("*")) {
                    everything = true;
                    continue;
                }
                patterns.add(supportedAnnotationType);
            }
            return new AutoValue_Processing_SupportedAnnotationTypes(everything, Pattern.compile(Joiner.on('|').join(patterns)));
        }
    }
}

