/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.runner.util.CharEscaper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class XmlEscapers {
    private static final char MIN_ASCII_CONTROL_CHAR = '\u0000';
    private static final char MAX_ASCII_CONTROL_CHAR = '\u001f';
    private static final CharEscaper XML_CONTENT_ESCAPER;
    private static final CharEscaper XML_ATTRIBUTE_ESCAPER;

    private XmlEscapers() {
    }

    public static CharEscaper xmlContentEscaper() {
        return XML_CONTENT_ESCAPER;
    }

    public static CharEscaper xmlAttributeEscaper() {
        return XML_ATTRIBUTE_ESCAPER;
    }

    static {
        Builder builder = Builder.builder();
        builder.setSafeRange('\u0000', '\ufffd');
        builder.setUnsafeReplacement("\ufffd");
        for (char c = '\u0000'; c <= '\u001f'; c = (char)((char)(c + 1))) {
            if (c == 9 || c == 10 || c == 13) continue;
            builder.addEscape(c, "\ufffd");
        }
        builder.addEscape('&', "&amp;");
        builder.addEscape('<', "&lt;");
        builder.addEscape('>', "&gt;");
        XML_CONTENT_ESCAPER = builder.build();
        builder.addEscape('\'', "&apos;");
        builder.addEscape('\"', "&quot;");
        builder.addEscape('\t', "&#x9;");
        builder.addEscape('\n', "&#xA;");
        builder.addEscape('\r', "&#xD;");
        XML_ATTRIBUTE_ESCAPER = builder.build();
    }

    static final class Builder {
        private final Map<Character, String> replacementMap = new HashMap<Character, String>();
        private char safeMin = '\u0000';
        private char safeMax = (char)65535;
        private String unsafeReplacement = null;

        static Builder builder() {
            return new Builder();
        }

        private Builder() {
        }

        @CanIgnoreReturnValue
        Builder setSafeRange(char safeMin, char safeMax) {
            this.safeMin = safeMin;
            this.safeMax = safeMax;
            return this;
        }

        @CanIgnoreReturnValue
        Builder setUnsafeReplacement(@Nullable String unsafeReplacement) {
            this.unsafeReplacement = unsafeReplacement;
            return this;
        }

        @CanIgnoreReturnValue
        Builder addEscape(char c, String replacement) {
            if (replacement == null) {
                throw new NullPointerException();
            }
            this.replacementMap.put(Character.valueOf(c), replacement);
            return this;
        }

        CharEscaper build() {
            return new CharEscaper(this.replacementMap, this.safeMin, this.safeMax){
                private final char[] replacementChars;
                {
                    super(replacementMap, safeMin, safeMax);
                    this.replacementChars = unsafeReplacement != null ? unsafeReplacement.toCharArray() : null;
                }

                @Override
                char[] escapeUnsafe(char c) {
                    return this.replacementChars;
                }
            };
        }
    }
}

