/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import com.google.testing.junit.runner.util.TestPropertyExporter;
import javax.annotation.Nullable;

public class TestPropertyRunnerIntegration {
    private static ThreadLocal<TestPropertyExporter.Callback> callbackForThread = new ThreadLocal<TestPropertyExporter.Callback>(){

        @Override
        protected TestPropertyExporter.Callback initialValue() {
            return NoOpCallback.INSTANCE;
        }
    };

    public static TestPropertyExporter.Callback setTestCaseForThread(@Nullable TestPropertyExporter.Callback callback) {
        TestPropertyExporter.Callback previousCallback = callbackForThread.get();
        if (callback == null) {
            callbackForThread.remove();
        } else {
            callbackForThread.set(callback);
        }
        return previousCallback;
    }

    static TestPropertyExporter.Callback getCallbackForThread() {
        return callbackForThread.get();
    }

    private static class NoOpCallback
    implements TestPropertyExporter.Callback {
        private static final TestPropertyExporter.Callback INSTANCE = new NoOpCallback();

        private NoOpCallback() {
        }

        @Override
        public void exportProperty(String name, String value) {
        }

        @Override
        public String exportRepeatedProperty(String name, String value) {
            return name;
        }
    }
}

