/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import com.google.testing.junit.runner.util.TestPropertyRunnerIntegration;
import java.util.HashMap;
import java.util.Map;

public class TestPropertyExporter {
    public static final TestPropertyExporter INSTANCE = new TestPropertyExporter(new DefaultCallback());
    public static final int INITIAL_INDEX_FOR_REPEATED_PROPERTY = 1000;
    private final Callback callback;

    public static TestPropertyExporter createFake(final Map<String, String> backingMap) {
        return TestPropertyExporter.createFake(new Callback(){
            private final Map<String, Integer> repeatedPropertyNamesToRepetitions = new HashMap<String, Integer>();

            @Override
            public void exportProperty(String name, String value) {
                backingMap.put(name, value);
            }

            @Override
            public String exportRepeatedProperty(String name, String value) {
                String propertyName = this.getRepeatedPropertyName(name);
                backingMap.put(propertyName, value);
                return propertyName;
            }

            private String getRepeatedPropertyName(String name) {
                int index = this.addNameToRepeatedPropertyNamesAndGetRepetitionsNr(name) + 1000;
                return name + index;
            }

            private synchronized int addNameToRepeatedPropertyNamesAndGetRepetitionsNr(String name) {
                Integer previousRepetitionsNr = this.repeatedPropertyNamesToRepetitions.get(name);
                if (previousRepetitionsNr == null) {
                    previousRepetitionsNr = 0;
                }
                this.repeatedPropertyNamesToRepetitions.put(name, previousRepetitionsNr + 1);
                return previousRepetitionsNr;
            }
        });
    }

    public static TestPropertyExporter createFake(Callback callback) {
        return new TestPropertyExporter(callback);
    }

    protected TestPropertyExporter(Callback callback) {
        this.callback = callback;
    }

    public void exportProperty(String name, String value) {
        this.callback.exportProperty(name, value);
    }

    public String exportRepeatedProperty(String name, String value) {
        return this.callback.exportRepeatedProperty(name, value);
    }

    private static class DefaultCallback
    implements Callback {
        private DefaultCallback() {
        }

        @Override
        public void exportProperty(String name, String value) {
            TestPropertyRunnerIntegration.getCallbackForThread().exportProperty(name, value);
        }

        @Override
        public String exportRepeatedProperty(String name, String value) {
            return TestPropertyRunnerIntegration.getCallbackForThread().exportRepeatedProperty(name, value);
        }
    }

    public static interface Callback {
        public void exportProperty(String var1, String var2);

        public String exportRepeatedProperty(String var1, String var2);
    }
}

