/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.EnumMap;
import java.util.Map;

public class TestIntegration {
    private final String contactEmail;
    private final String componentId;
    private final String name;
    private final String url;
    private final String iconUrl;
    private final String iconName;
    private final String description;
    private final String foregroundColor;
    private final String backgroundColor;

    public TestIntegration(String contactEmail, String componentId, String name, String url, String iconUrl, String iconName, String description, String foregroundColor, String backgroundColor) {
        this.contactEmail = contactEmail;
        this.componentId = componentId;
        this.name = name;
        this.url = url;
        this.iconUrl = iconUrl;
        this.iconName = iconName;
        this.description = description;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
    }

    String contactEmail() {
        return this.contactEmail;
    }

    String componentId() {
        return this.componentId;
    }

    String name() {
        return this.name;
    }

    String url() {
        return this.url;
    }

    String iconUrl() {
        return this.iconUrl;
    }

    String iconName() {
        return this.iconName;
    }

    String description() {
        return this.description;
    }

    String foregroundColor() {
        return this.foregroundColor;
    }

    String backgroundColor() {
        return this.backgroundColor;
    }

    public static Builder builder() {
        return new Builder().setIconName("").setIconUrl("").setDescription("").setForegroundColor("").setBackgroundColor("");
    }

    public Map<ExternalLinkAttribute, String> getAttributeValueMap() {
        EnumMap<ExternalLinkAttribute, String> map = new EnumMap<ExternalLinkAttribute, String>(ExternalLinkAttribute.class);
        map.put(ExternalLinkAttribute.NAME, this.name());
        map.put(ExternalLinkAttribute.URL, this.url());
        map.put(ExternalLinkAttribute.CONTACT_EMAIL, this.contactEmail());
        map.put(ExternalLinkAttribute.COMPONENT_ID, this.componentId());
        map.put(ExternalLinkAttribute.DESCRIPTION, this.description());
        map.put(ExternalLinkAttribute.ICON_NAME, this.iconName());
        map.put(ExternalLinkAttribute.ICON_URL, this.iconUrl());
        map.put(ExternalLinkAttribute.BACKGROUND_COLOR, this.backgroundColor());
        map.put(ExternalLinkAttribute.FOREGROUND_COLOR, this.foregroundColor());
        return map;
    }

    public static class Builder {
        private String contactEmail;
        private String componentId;
        private String name;
        private String url;
        private String iconUrl;
        private String iconName;
        private String description;
        private String foregroundColor;
        private String backgroundColor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setContactEmail(String email) {
            this.contactEmail = email;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setComponentId(String id) {
            this.componentId = id;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIconName(String iconName) {
            this.iconName = iconName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setForegroundColor(String foregroundColor) {
            this.foregroundColor = foregroundColor;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public TestIntegration build() {
            return new TestIntegration(this.contactEmail, this.componentId, this.name, this.url, this.iconUrl, this.iconName, this.description, this.foregroundColor, this.backgroundColor);
        }
    }

    public static enum ExternalLinkAttribute {
        NAME,
        URL,
        CONTACT_EMAIL,
        COMPONENT_ID,
        DESCRIPTION,
        ICON_NAME,
        ICON_URL,
        BACKGROUND_COLOR,
        FOREGROUND_COLOR;


        public String getXmlAttributeName() {
            return this.name().toLowerCase();
        }
    }
}

