/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import java.time.Duration;
import java.time.Instant;

public abstract class TestClock {
    private static final TestClock SYSTEM_TEST_CLOCK = new TestClock(){

        @Override
        public Duration monotonicTime() {
            return Duration.ofNanos(System.nanoTime());
        }

        @Override
        public Instant wallTime() {
            return Instant.ofEpochMilli(System.currentTimeMillis());
        }
    };

    protected TestClock() {
    }

    public TestInstant now() {
        return new TestInstant(this.wallTime(), this.monotonicTime());
    }

    abstract Duration monotonicTime();

    abstract Instant wallTime();

    public static TestClock systemClock() {
        return SYSTEM_TEST_CLOCK;
    }

    public static class TestInstant {
        public static final TestInstant UNKNOWN = new TestInstant(Instant.EPOCH, Duration.ZERO);
        private final Instant wallTime;
        private final Duration monotonicTime;

        public TestInstant(Instant wallTime, Duration monotonicTime) {
            this.wallTime = wallTime;
            this.monotonicTime = monotonicTime;
        }

        public Instant wallTime() {
            return this.wallTime;
        }

        public Duration monotonicTime() {
            return this.monotonicTime;
        }
    }
}

