/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import java.security.Permission;

public final class GoogleTestSecurityManager
extends SecurityManager {
    private volatile boolean enabled = true;
    private final RuntimePermission securityManagerPermission = new RuntimePermission("setSecurityManager");

    @Override
    public void checkExit(int code) {
        if (this.enabled) {
            throw new SecurityException("Test code should never call System.exit()");
        }
    }

    @Override
    public void checkPermission(Permission p) {
        if (this.enabled && this.securityManagerPermission.equals(p)) {
            throw new SecurityException("GoogleTestSecurityManager is not designed to handle other security managers.");
        }
    }

    @Override
    public void checkPermission(Permission p, Object o) {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static void uninstallIfInstalled() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof GoogleTestSecurityManager) {
            GoogleTestSecurityManager testSecurityManager = (GoogleTestSecurityManager)securityManager;
            boolean wasEnabled = testSecurityManager.isEnabled();
            try {
                testSecurityManager.setEnabled(false);
                System.setSecurityManager(null);
            }
            finally {
                testSecurityManager.setEnabled(wasEnabled);
            }
        }
    }

    synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

