/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.runner.util.TestClock;
import java.time.Duration;
import java.time.Instant;

public class FakeTestClock
extends TestClock {
    private Instant wallTimeOffset = Instant.EPOCH;
    private Duration monotonic = Duration.ZERO;
    private Duration autoIncrementStep = Duration.ZERO;

    @CanIgnoreReturnValue
    public synchronized FakeTestClock advance(Duration duration) {
        this.monotonic = this.monotonic.plus(duration);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized FakeTestClock setAutoIncrementStep(Duration autoIncrementStep) {
        if (autoIncrementStep.toNanos() < 0L) {
            throw new IllegalArgumentException("May not auto-increment by a negative amount");
        }
        this.autoIncrementStep = autoIncrementStep;
        return this;
    }

    public void setWallTimeOffset(Instant wallTimeOffset) {
        this.wallTimeOffset = wallTimeOffset;
    }

    @Override
    Duration monotonicTime() {
        return this.monotonic;
    }

    @Override
    Instant wallTime() {
        return this.wallTimeOffset.plus(this.monotonic);
    }

    @Override
    public synchronized TestClock.TestInstant now() {
        this.advance(this.autoIncrementStep);
        return super.now();
    }
}

