/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.util;

import java.util.Collections;
import java.util.Map;

public abstract class CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;
    private static final int DEST_PAD_MULTIPLIER = 2;
    private static final ThreadLocal<char[]> DEST_TL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    public CharEscaper(Map<Character, String> replacementMap, char safeMin, char safeMax) {
        this.replacements = CharEscaper.createReplacementArray(replacementMap);
        this.replacementsLength = this.replacements.length;
        this.safeMin = safeMin;
        this.safeMax = safeMax;
    }

    public final String escape(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c >= this.replacementsLength || this.replacements[c] == null) && c <= this.safeMax && c >= this.safeMin) continue;
            return this.escapeSlow(s, i);
        }
        return s;
    }

    final char[] escape(char c) {
        char[] chars;
        if (c < this.replacementsLength && (chars = this.replacements[c]) != null) {
            return chars;
        }
        if (c >= this.safeMin && c <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(c);
    }

    final String escapeSlow(String s, int index) {
        int slen = s.length();
        char[] dest = DEST_TL.get();
        int destSize = dest.length;
        int destIndex = 0;
        int lastEscape = 0;
        while (index < slen) {
            char[] r = this.escape(s.charAt(index));
            if (r != null) {
                int charsSkipped = index - lastEscape;
                int rlen = r.length;
                int sizeNeeded = destIndex + charsSkipped + rlen;
                if (destSize < sizeNeeded) {
                    destSize = sizeNeeded + 2 * (slen - index);
                    dest = CharEscaper.growBuffer(dest, destIndex, destSize);
                }
                if (charsSkipped > 0) {
                    s.getChars(lastEscape, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (rlen > 0) {
                    System.arraycopy(r, 0, dest, destIndex, rlen);
                    destIndex += rlen;
                }
                lastEscape = index + 1;
            }
            ++index;
        }
        int charsLeft = slen - lastEscape;
        if (charsLeft > 0) {
            int sizeNeeded = destIndex + charsLeft;
            if (destSize < sizeNeeded) {
                dest = CharEscaper.growBuffer(dest, destIndex, sizeNeeded);
            }
            s.getChars(lastEscape, slen, dest, destIndex);
            destIndex = sizeNeeded;
        }
        return new String(dest, 0, destIndex);
    }

    abstract char[] escapeUnsafe(char var1);

    private static char[] growBuffer(char[] dest, int index, int size) {
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy(dest, 0, copy, 0, index);
        }
        return copy;
    }

    private static char[][] createReplacementArray(Map<Character, String> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.isEmpty()) {
            return new char[0][0];
        }
        char max = Collections.max(map.keySet()).charValue();
        char[][] replacements = new char[max + '\u0001'][];
        for (char c : map.keySet()) {
            replacements[c] = map.get(Character.valueOf(c)).toCharArray();
        }
        return replacements;
    }
}

