/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.sharding;

import com.google.testing.junit.runner.sharding.HashBackedShardingFilter;
import com.google.testing.junit.runner.sharding.RoundRobinShardingFilter;
import com.google.testing.junit.runner.sharding.ShardingEnvironment;
import com.google.testing.junit.runner.sharding.api.ShardingFilterFactory;
import java.util.Collection;
import java.util.Locale;
import javax.inject.Inject;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class ShardingFilters {
    public static final ShardingFilterFactory DEFAULT_SHARDING_STRATEGY = ShardingStrategy.ROUND_ROBIN;
    private final ShardingEnvironment shardingEnvironment;
    private final ShardingFilterFactory defaultShardingStrategy;

    public ShardingFilters(ShardingEnvironment shardingEnvironment) {
        this(shardingEnvironment, DEFAULT_SHARDING_STRATEGY);
    }

    @Inject
    public ShardingFilters(ShardingEnvironment shardingEnvironment, ShardingFilterFactory defaultShardingStrategy) {
        this.shardingEnvironment = shardingEnvironment;
        this.defaultShardingStrategy = defaultShardingStrategy;
    }

    public Filter createShardingFilter(Collection<Description> descriptions) {
        ShardingFilterFactory factory = this.getShardingFilterFactory();
        return factory.createFilter(descriptions, this.shardingEnvironment.getShardIndex(), this.shardingEnvironment.getTotalShards());
    }

    private ShardingFilterFactory getShardingFilterFactory() {
        ShardingFilterFactory shardingFilterFactory;
        String strategy = this.shardingEnvironment.getTestShardingStrategy();
        if (strategy == null) {
            return this.defaultShardingStrategy;
        }
        try {
            shardingFilterFactory = ShardingStrategy.valueOf(strategy.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<ShardingFilterFactory> strategyClass = classLoader.loadClass(strategy).asSubclass(ShardingFilterFactory.class);
                shardingFilterFactory = strategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e2) {
                throw new RuntimeException("Could not create custom sharding strategy class " + strategy, e2);
            }
        }
        return shardingFilterFactory;
    }

    public static enum ShardingStrategy implements ShardingFilterFactory
    {
        HASH{

            @Override
            public Filter createFilter(Collection<Description> testDescriptions, int shardIndex, int totalShards) {
                return new HashBackedShardingFilter(shardIndex, totalShards);
            }
        }
        ,
        ROUND_ROBIN{

            @Override
            public Filter createFilter(Collection<Description> testDescriptions, int shardIndex, int totalShards) {
                return new RoundRobinShardingFilter(testDescriptions, shardIndex, totalShards);
            }
        };

    }
}

