/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.sharding;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;

public class ShardingEnvironment {
    public static final ShardingEnvironment DEFAULT = new ShardingEnvironment();
    private static final String TEST_SHARDING_STRATEGY = "test.sharding.strategy";

    @Inject
    public ShardingEnvironment() {
    }

    public boolean isShardingEnabled() {
        return System.getenv("TEST_TOTAL_SHARDS") != null;
    }

    public int getShardIndex() {
        String shardIndex = System.getenv("TEST_SHARD_INDEX");
        return shardIndex == null ? 0 : Integer.parseInt(shardIndex);
    }

    public int getTotalShards() {
        String totalShards = System.getenv("TEST_TOTAL_SHARDS");
        return totalShards == null ? 1 : Integer.parseInt(totalShards);
    }

    public void touchShardFile() {
        String shardStatusPath = System.getenv("TEST_SHARD_STATUS_FILE");
        File shardFile = shardStatusPath == null ? null : new File(shardStatusPath);
        ShardingEnvironment.touchShardFile(shardFile);
    }

    static void touchShardFile(File shardFile) {
        if (shardFile != null) {
            try {
                if (!shardFile.createNewFile() && !shardFile.setLastModified(System.currentTimeMillis())) {
                    throw new IOException("Unable to update modification time of " + shardFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing shard file " + shardFile, e);
            }
        }
    }

    public String getTestShardingStrategy() {
        return System.getProperty(TEST_SHARDING_STRATEGY);
    }
}

