/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.sharding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public final class RoundRobinShardingFilter
extends Filter {
    final Map<Description, Integer> testToShardMap;
    final int shardIndex;
    final int totalShards;

    public RoundRobinShardingFilter(Collection<Description> testDescriptions, int shardIndex, int totalShards) {
        if (shardIndex < 0 || totalShards <= shardIndex) {
            throw new IllegalArgumentException();
        }
        this.testToShardMap = RoundRobinShardingFilter.buildTestToShardMap(testDescriptions);
        this.shardIndex = shardIndex;
        this.totalShards = totalShards;
    }

    private static Map<Description, Integer> buildTestToShardMap(Collection<Description> testDescriptions) {
        HashMap<Description, Integer> map = new HashMap<Description, Integer>();
        ArrayList<Description> sortedDescriptions = new ArrayList<Description>(testDescriptions);
        Collections.sort(sortedDescriptions, new DescriptionComparator());
        int index = 0;
        for (Description description : sortedDescriptions) {
            if (!description.isTest()) {
                throw new IllegalArgumentException("Test suite should not be included in the set of tests to shard: " + description.getDisplayName());
            }
            map.put(description, index);
            ++index;
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public boolean shouldRun(Description description) {
        if (description.isSuite()) {
            return true;
        }
        Integer testNumber = this.testToShardMap.get(description);
        if (testNumber == null) {
            throw new IllegalArgumentException("This filter keeps a mapping from each test description to a shard, and the given description was not passed in when filter was constructed: " + description);
        }
        return testNumber % this.totalShards == this.shardIndex;
    }

    @Override
    public String describe() {
        return "round robin sharding filter";
    }

    static class DescriptionComparator
    implements Comparator<Description> {
        DescriptionComparator() {
        }

        @Override
        public int compare(Description d1, Description d2) {
            return d1.getDisplayName().compareTo(d2.getDisplayName());
        }
    }
}

