/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.sharding;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

final class HashBackedShardingFilter
extends Filter {
    private final int shardIndex;
    private final int totalShards;

    public HashBackedShardingFilter(int shardIndex, int totalShards) {
        if (shardIndex < 0 || totalShards <= shardIndex) {
            throw new IllegalArgumentException();
        }
        this.shardIndex = shardIndex;
        this.totalShards = totalShards;
    }

    @Override
    public boolean shouldRun(Description description) {
        if (description.isSuite()) {
            return true;
        }
        int mod = description.getDisplayName().hashCode() % this.totalShards;
        if (mod < 0) {
            mod += this.totalShards;
        }
        if (mod < 0 || mod >= this.totalShards) {
            throw new IllegalStateException();
        }
        return mod == this.shardIndex;
    }

    @Override
    public String describe() {
        return "hash-backed sharding filter";
    }
}

