/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.util.XmlEscapers;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class XmlWriter {
    static final String EOL = System.getProperty("line.separator", "\n");
    private final Writer writer;
    private boolean started;
    private boolean inElement;
    private final List<String> elementStack = new ArrayList<String>();

    public XmlWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    private XmlWriter(Writer writer) {
        this.writer = writer;
    }

    public static XmlWriter createForTesting(StringWriter writer) {
        return new XmlWriter(writer);
    }

    public void startDocument() throws IOException {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        Writer out = this.writer;
        out.write("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void close() throws IOException {
        while (!this.elementStack.isEmpty()) {
            this.endElement();
        }
        this.writer.append(EOL);
        this.writer.close();
    }

    private void closeElement() throws IOException {
        if (this.inElement) {
            this.writer.append('>');
            this.inElement = false;
        }
    }

    private String indentation() {
        int stackSize = this.elementStack.size();
        StringBuilder ident = new StringBuilder(2 * stackSize);
        for (int i = 0; i < stackSize; ++i) {
            ident.append("  ");
        }
        return ident.toString();
    }

    public void startElement(String elementName) throws IOException {
        if (!this.started) {
            throw new IllegalStateException();
        }
        this.closeElement();
        this.inElement = true;
        this.writer.append(EOL + this.indentation() + "<" + elementName);
        this.elementStack.add(elementName);
    }

    public void endElement() throws IOException {
        String elementName = this.elementStack.remove(this.elementStack.size() - 1);
        if (this.inElement) {
            this.writer.write(" />");
            this.inElement = false;
        } else {
            this.writer.write("</");
            this.writer.write(elementName);
            this.writer.write(62);
        }
    }

    public void writeAttribute(String name, int value) throws IOException {
        this.writeAttributeWithoutEscaping(name, String.valueOf(value));
    }

    public void writeAttribute(String name, double value) throws IOException {
        this.writeAttributeWithoutEscaping(name, String.valueOf(value));
    }

    public void writeAttribute(String name, String value) throws IOException {
        if (value != null) {
            value = XmlEscapers.xmlAttributeEscaper().escape(value);
        }
        this.writeAttributeWithoutEscaping(name, value);
    }

    private void writeAttributeWithoutEscaping(String name, String value) throws IOException {
        this.writer.write(" " + name + "='");
        if (value != null) {
            this.writer.write(value);
        }
        this.writer.write("'");
    }

    public void writeCharacters(String text) throws IOException {
        this.closeElement();
        if (text == null || text.isEmpty()) {
            return;
        }
        this.writer.write(XmlEscapers.xmlContentEscaper().escape(text));
    }

    Writer getUnderlyingWriter() {
        return this.writer;
    }
}

