/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.model.TestCaseNode;
import com.google.testing.junit.runner.model.TestInterval;
import com.google.testing.junit.runner.model.TestNode;
import com.google.testing.junit.runner.model.TestResult;
import com.google.testing.junit.runner.util.TestClock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;

class TestSuiteNode
extends TestNode {
    private final List<TestNode> children = new ArrayList<TestNode>();
    private final Map<String, String> properties;

    TestSuiteNode(Description description) {
        this(description, Collections.emptyMap());
    }

    TestSuiteNode(Description description, Map<String, String> properties) {
        super(description);
        this.properties = properties;
    }

    @Override
    public List<TestNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public boolean isTestCase() {
        return false;
    }

    @Override
    public void testFailure(Throwable throwable, TestClock.TestInstant now) {
        for (TestNode child : this.getChildren()) {
            child.testFailure(throwable, now);
        }
    }

    @Override
    public void dynamicTestFailure(Description test, Throwable throwable, TestClock.TestInstant now) {
        for (TestNode child : this.getChildren()) {
            child.dynamicTestFailure(test, throwable, now);
        }
    }

    @Override
    public void testInterrupted(TestClock.TestInstant now) {
        for (TestNode child : this.getChildren()) {
            child.testInterrupted(now);
        }
    }

    @Override
    public void testSkipped(TestClock.TestInstant now) {
        for (TestNode child : this.getChildren()) {
            child.testSkipped(now);
        }
    }

    @Override
    public void testSuppressed(TestClock.TestInstant now) {
        for (TestNode child : this.getChildren()) {
            child.testSuppressed(now);
        }
    }

    void addTestSuite(TestSuiteNode suite) {
        this.children.add(suite);
    }

    void addTestCase(TestCaseNode testCase) {
        this.children.add(testCase);
    }

    @Override
    protected TestResult buildResult() {
        TestInterval runTime = null;
        int numTests = 0;
        int numFailures = 0;
        LinkedList<TestResult> childResults = new LinkedList<TestResult>();
        for (TestNode child : this.children) {
            TestResult childResult = child.getResult();
            childResults.add(childResult);
            numTests += childResult.getNumTests();
            numFailures += childResult.getNumFailures();
            TestInterval childRunTime = childResult.getRunTimeInterval();
            if (childRunTime == null) continue;
            runTime = runTime == null ? childRunTime : TestInterval.around(runTime, childRunTime);
        }
        return new TestResult.Builder().name(this.getDescription().getDisplayName()).className("").properties(this.properties).failures(Collections.emptyList()).runTimeInterval(runTime).status(TestResult.Status.SKIPPED).numTests(numTests).numFailures(numFailures).childResults(childResults).integrations(Collections.emptySet()).build();
    }
}

