/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.junit4.runner.DynamicTestException;
import com.google.testing.junit.runner.model.TestCaseNode;
import com.google.testing.junit.runner.model.TestNode;
import com.google.testing.junit.runner.model.TestSuiteNode;
import com.google.testing.junit.runner.model.XmlResultWriter;
import com.google.testing.junit.runner.model.XmlWriter;
import com.google.testing.junit.runner.sharding.ShardingEnvironment;
import com.google.testing.junit.runner.sharding.ShardingFilters;
import com.google.testing.junit.runner.util.TestClock;
import com.google.testing.junit.runner.util.TestIntegrationsRunnerIntegration;
import com.google.testing.junit.runner.util.TestPropertyRunnerIntegration;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class TestSuiteModel {
    private final TestSuiteNode rootNode;
    private final Map<Description, TestCaseNode> testCaseMap;
    private final Map<Description, TestNode> testsMap;
    private final TestClock testClock;
    private final AtomicBoolean wroteXml = new AtomicBoolean(false);
    private final XmlResultWriter xmlResultWriter;
    @Nullable
    private final Filter shardingFilter;

    private TestSuiteModel(Builder builder) {
        this.rootNode = builder.rootNode;
        this.testsMap = builder.testsMap;
        this.testCaseMap = TestSuiteModel.filterTestCases(builder.testsMap);
        this.testClock = builder.testClock;
        this.shardingFilter = builder.shardingFilter;
        this.xmlResultWriter = builder.xmlResultWriter;
    }

    public List<TestNode> getTopLevelTestSuites() {
        return this.rootNode.getChildren();
    }

    public Description getTopLevelDescription() {
        return this.rootNode.getDescription();
    }

    public Filter getShardingFilter() {
        return this.shardingFilter;
    }

    private TestCaseNode getTestCase(Description description) {
        return description == null ? null : this.testCaseMap.get(description);
    }

    private TestNode getTest(Description description) {
        return description == null ? null : this.testsMap.get(description);
    }

    public int getNumTestCases() {
        return this.testCaseMap.size();
    }

    public void testRunStarted(Description topLevelDescription) {
        this.markChildrenAsPending(topLevelDescription);
    }

    private void markChildrenAsPending(Description node) {
        if (node.isTest()) {
            this.testPending(node);
        } else {
            for (Description child : node.getChildren()) {
                this.markChildrenAsPending(child);
            }
        }
    }

    private void testPending(Description description) {
        TestCaseNode testCase = this.getTestCase(description);
        if (testCase != null) {
            testCase.pending();
        }
    }

    public void testStarted(Description description) {
        TestCaseNode testCase = this.getTestCase(description);
        if (testCase != null) {
            testCase.started(this.now());
            TestPropertyRunnerIntegration.setTestCaseForThread(testCase);
            TestIntegrationsRunnerIntegration.setTestCaseForThread(testCase);
        }
    }

    public void testRunInterrupted() {
        this.rootNode.testInterrupted(this.now());
    }

    public void testEmittedProperty(Description description, String name, String value) {
        TestCaseNode testCase = this.getTestCase(description);
        if (testCase != null) {
            testCase.exportProperty(name, value);
        }
    }

    public void testFailure(Description description, Throwable throwable) {
        TestNode test = this.getTest(description);
        if (test != null) {
            if (throwable instanceof DynamicTestException) {
                DynamicTestException dynamicFailure = (DynamicTestException)throwable;
                test.dynamicTestFailure(dynamicFailure.getTest(), dynamicFailure.getCause(), this.now());
            } else {
                test.testFailure(throwable, this.now());
            }
        }
    }

    public void testSkipped(Description description) {
        TestNode test = this.getTest(description);
        if (test != null) {
            test.testSkipped(this.now());
        }
    }

    public void testSuppressed(Description description) {
        TestNode test = this.getTest(description);
        if (test != null) {
            test.testSuppressed(this.now());
        }
    }

    public void testFinished(Description description) {
        TestCaseNode testCase = this.getTestCase(description);
        if (testCase != null) {
            testCase.finished(this.now());
        }
    }

    private TestClock.TestInstant now() {
        return this.testClock.now();
    }

    public void writeAsXml(OutputStream outputStream) throws IOException {
        this.write(new XmlWriter(outputStream));
    }

    public void write(XmlWriter writer) throws IOException {
        if (this.wroteXml.compareAndSet(false, true)) {
            this.xmlResultWriter.writeTestSuites(writer, this.rootNode.getResult());
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestSuiteModel)) {
            return false;
        }
        TestSuiteModel that = (TestSuiteModel)obj;
        return this.toString().equals(that.toString());
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(XmlWriter.createForTesting(stringWriter));
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Description, TestCaseNode> filterTestCases(Map<Description, TestNode> tests) {
        HashMap<Description, TestCaseNode> filteredAndConvertedTests = new HashMap<Description, TestCaseNode>();
        for (Description key : tests.keySet()) {
            TestNode testNode = tests.get(key);
            if (!(testNode instanceof TestCaseNode)) continue;
            filteredAndConvertedTests.put(key, (TestCaseNode)testNode);
        }
        return filteredAndConvertedTests;
    }

    public static class Builder {
        private final TestClock testClock;
        private final Map<Description, TestNode> testsMap = new ConcurrentHashMap<Description, TestNode>();
        private final ShardingEnvironment shardingEnvironment;
        private final ShardingFilters shardingFilters;
        private final XmlResultWriter xmlResultWriter;
        private TestSuiteNode rootNode;
        private Filter shardingFilter = Filter.ALL;
        private boolean buildWasCalled = false;

        @Inject
        public Builder(TestClock testClock, ShardingFilters shardingFilters, ShardingEnvironment shardingEnvironment, XmlResultWriter xmlResultWriter) {
            this.testClock = testClock;
            this.shardingFilters = shardingFilters;
            this.shardingEnvironment = shardingEnvironment;
            this.xmlResultWriter = xmlResultWriter;
        }

        public TestSuiteModel build(String suiteName, Description ... topLevelSuites) {
            return this.build(suiteName, Collections.emptyMap(), topLevelSuites);
        }

        public TestSuiteModel build(String suiteName, Map<String, String> properties, Description ... topLevelSuites) {
            if (this.buildWasCalled) {
                throw new IllegalStateException("Builder.build() was already called");
            }
            this.buildWasCalled = true;
            if (this.shardingEnvironment.isShardingEnabled()) {
                this.shardingFilter = this.getShardingFilter(topLevelSuites);
            }
            this.rootNode = new TestSuiteNode(Description.createSuiteDescription(suiteName, new Annotation[0]), properties);
            for (Description topLevelSuite : topLevelSuites) {
                this.addTestSuite(this.rootNode, topLevelSuite);
                this.rootNode.getDescription().addChild(topLevelSuite);
            }
            return new TestSuiteModel(this);
        }

        private Filter getShardingFilter(Description ... topLevelSuites) {
            LinkedList<Description> tests = new LinkedList<Description>();
            for (Description suite : topLevelSuites) {
                Builder.collectTests(suite, tests);
            }
            this.shardingEnvironment.touchShardFile();
            return this.shardingFilters.createShardingFilter(tests);
        }

        private static void collectTests(Description desc, Collection<Description> tests) {
            if (desc.isTest()) {
                tests.add(desc);
            } else {
                for (Description child : desc.getChildren()) {
                    Builder.collectTests(child, tests);
                }
            }
        }

        private void addTestSuite(TestSuiteNode parentSuite, Description suiteDescription) {
            TestSuiteNode suite = new TestSuiteNode(suiteDescription);
            for (Description childDesc : suiteDescription.getChildren()) {
                if (childDesc.isTest()) {
                    this.addTestCase(suite, childDesc);
                    continue;
                }
                this.addTestSuite(suite, childDesc);
            }
            if (this.shardingFilter == Filter.ALL || !suite.getChildren().isEmpty()) {
                parentSuite.addTestSuite(suite);
                this.testsMap.put(suiteDescription, suite);
            }
        }

        private void addTestCase(TestSuiteNode parentSuite, Description testCaseDesc) {
            if (!testCaseDesc.isTest()) {
                throw new IllegalArgumentException();
            }
            if (!this.shardingFilter.shouldRun(testCaseDesc)) {
                return;
            }
            TestCaseNode testCase = new TestCaseNode(testCaseDesc, parentSuite);
            this.testsMap.put(testCaseDesc, testCase);
            parentSuite.addTestCase(testCase);
        }
    }
}

