/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.runner.model.TestInterval;
import com.google.testing.junit.runner.util.TestIntegration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class TestResult {
    private final String name;
    private final String className;
    private final Map<String, String> properties;
    private final List<Throwable> failures;
    @Nullable
    private final TestInterval runTime;
    private final Set<TestIntegration> integrations;
    private final Status status;
    private final int numTests;
    private final int numFailures;
    private final List<TestResult> childResults;

    private TestResult(Builder builder) {
        this.name = TestResult.checkNotNull(builder.name, "name not set");
        this.className = TestResult.checkNotNull(builder.className, "className not set");
        this.properties = TestResult.checkNotNull(builder.properties, "properties not set");
        this.failures = TestResult.checkNotNull(builder.failures, "failures not set");
        this.runTime = builder.runTime;
        this.status = TestResult.checkNotNull(builder.status, "status not set");
        this.numTests = TestResult.checkNotNull(builder.numTests, "numTests not set");
        this.numFailures = TestResult.checkNotNull(builder.numFailures, "numFailures not set");
        this.childResults = TestResult.checkNotNull(builder.childResults, "childResults not set");
        this.integrations = TestResult.checkNotNull(builder.integrations, "integrations not set");
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public Set<TestIntegration> getIntegrations() {
        return this.integrations;
    }

    @Nullable
    public TestInterval getRunTimeInterval() {
        return this.runTime;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean wasRun() {
        return this.getStatus().wasRun();
    }

    public int getNumTests() {
        return this.numTests;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public List<TestResult> getChildResults() {
        return this.childResults;
    }

    private static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static final class Builder {
        private String name = null;
        private String className = null;
        private Map<String, String> properties = null;
        private List<Throwable> failures = null;
        @Nullable
        private TestInterval runTime = null;
        private Set<TestIntegration> integrations = null;
        private Status status = null;
        private Integer numTests = null;
        private Integer numFailures = null;
        private List<TestResult> childResults = null;

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.name = Builder.checkNullToNotNull(this.name, name, "name");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder className(String className) {
            this.className = Builder.checkNullToNotNull(this.className, className, "className");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder properties(Map<String, String> properties) {
            this.properties = Builder.checkNullToNotNull(this.properties, properties, "properties");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder integrations(Set<TestIntegration> integrations) {
            this.integrations = Builder.checkNullToNotNull(this.integrations, integrations, "integrations");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder failures(List<Throwable> failures) {
            this.failures = Builder.checkNullToNotNull(this.failures, failures, "failures");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder runTimeInterval(@Nullable TestInterval runTime) {
            if (this.runTime != null) {
                throw new IllegalStateException("runTime already set");
            }
            this.runTime = runTime;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder status(Status status) {
            this.status = Builder.checkNullToNotNull(this.status, status, "status");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder numTests(int numTests) {
            this.numTests = Builder.checkNullToNotNull(this.numTests, numTests, "numTests");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder numFailures(int numFailures) {
            this.numFailures = Builder.checkNullToNotNull(this.numFailures, numFailures, "numFailures");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder childResults(List<TestResult> childResults) {
            this.childResults = Builder.checkNullToNotNull(this.childResults, childResults, "childResults");
            return this;
        }

        public TestResult build() {
            return new TestResult(this);
        }

        private static <T> T checkNullToNotNull(T currValue, T newValue, String desc) {
            if (currValue != null) {
                throw new IllegalStateException(desc + " already set");
            }
            return (T)TestResult.checkNotNull(newValue, desc + " is null");
        }
    }

    public static enum Status {
        SKIPPED(false),
        FILTERED(false),
        SUPPRESSED(false),
        CANCELLED(false),
        INTERRUPTED(true),
        COMPLETED(true);

        private final boolean wasRun;

        private Status(boolean wasRun) {
            this.wasRun = wasRun;
        }

        public boolean wasRun() {
            return this.wasRun;
        }
    }
}

