/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.model.TestResult;
import com.google.testing.junit.runner.util.TestClock;
import java.util.List;
import javax.annotation.Nullable;
import org.junit.runner.Description;

public abstract class TestNode {
    private final Description description;
    @Nullable
    private TestResult result = null;

    TestNode(Description description) {
        if (description == null) {
            throw new NullPointerException();
        }
        this.description = description;
    }

    public final Description getDescription() {
        return this.description;
    }

    public abstract List<TestNode> getChildren();

    public abstract boolean isTestCase();

    public abstract void testSkipped(TestClock.TestInstant var1);

    public abstract void testSuppressed(TestClock.TestInstant var1);

    public abstract void testInterrupted(TestClock.TestInstant var1);

    public abstract void testFailure(Throwable var1, TestClock.TestInstant var2);

    public abstract void dynamicTestFailure(Description var1, Throwable var2, TestClock.TestInstant var3);

    protected abstract TestResult buildResult();

    public final TestResult getResult() {
        if (this.result == null) {
            this.result = this.buildResult();
        }
        return this.result;
    }
}

