/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.util.TestClock;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;

public final class TestInterval {
    private static final DateTimeFormatter ISO8601_WITH_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();
    private final TestClock.TestInstant startInstant;
    private final TestClock.TestInstant endInstant;

    public TestInterval(TestClock.TestInstant startInstant, TestClock.TestInstant endInstant) {
        if (startInstant.monotonicTime().compareTo(endInstant.monotonicTime()) > 0) {
            throw new IllegalArgumentException("Start must be before end");
        }
        this.startInstant = startInstant;
        this.endInstant = endInstant;
    }

    public long getStartMillis() {
        return this.startInstant.wallTime().toEpochMilli();
    }

    public long getEndMillis() {
        return this.endInstant.wallTime().toEpochMilli();
    }

    public long toDurationMillis() {
        return this.endInstant.monotonicTime().minus(this.startInstant.monotonicTime()).toMillis();
    }

    public TestInterval withEndMillis(TestClock.TestInstant now) {
        return new TestInterval(this.startInstant, now);
    }

    public String startInstantToString() {
        return ISO8601_WITH_MILLIS_FORMATTER.format(this.startInstant.wallTime());
    }

    public static TestInterval around(TestInterval a, TestInterval b) {
        TestClock.TestInstant start = a.startInstant.monotonicTime().compareTo(b.startInstant.monotonicTime()) < 0 ? a.startInstant : b.startInstant;
        TestClock.TestInstant end = a.endInstant.monotonicTime().compareTo(b.endInstant.monotonicTime()) > 0 ? a.endInstant : b.endInstant;
        return new TestInterval(start, end);
    }
}

