/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.model.TestInterval;
import com.google.testing.junit.runner.model.TestNode;
import com.google.testing.junit.runner.model.TestResult;
import com.google.testing.junit.runner.model.TestSuiteNode;
import com.google.testing.junit.runner.util.TestClock;
import com.google.testing.junit.runner.util.TestIntegration;
import com.google.testing.junit.runner.util.TestIntegrationsExporter;
import com.google.testing.junit.runner.util.TestPropertyExporter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.junit.runner.Description;

class TestCaseNode
extends TestNode
implements TestPropertyExporter.Callback,
TestIntegrationsExporter.Callback {
    private static final Set<State> INITIAL_STATES = Collections.unmodifiableSet(EnumSet.of(State.INITIAL, State.PENDING));
    private final TestSuiteNode parent;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final Map<String, Integer> repeatedPropertyNamesToRepetitions = new HashMap<String, Integer>();
    private final Queue<Throwable> globalFailures = new ConcurrentLinkedQueue<Throwable>();
    private final ConcurrentMap<Description, List<Throwable>> dynamicTestToFailures = new ConcurrentHashMap<Description, List<Throwable>>();
    private final Set<TestIntegration> integrations = Collections.newSetFromMap(new ConcurrentHashMap());
    @Nullable
    private volatile TestInterval runTimeInterval = null;
    private volatile State state = State.INITIAL;

    TestCaseNode(Description description, TestSuiteNode parent) {
        super(description);
        this.parent = parent;
    }

    @Override
    public List<TestNode> getChildren() {
        return Collections.emptyList();
    }

    void pending() {
        this.compareAndSetState(State.INITIAL, State.PENDING, TestClock.TestInstant.UNKNOWN);
    }

    public void started(TestClock.TestInstant now) {
        this.compareAndSetState(INITIAL_STATES, State.STARTED, now);
    }

    @Override
    public void testInterrupted(TestClock.TestInstant now) {
        if (this.compareAndSetState(State.STARTED, State.INTERRUPTED, now)) {
            this.globalFailures.add(new Exception("Test interrupted"));
            return;
        }
        if (this.compareAndSetState(INITIAL_STATES, State.CANCELLED, now)) {
            this.globalFailures.add(new Exception("Test cancelled"));
        }
    }

    @Override
    public void exportProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public String exportRepeatedProperty(String name, String value) {
        String propertyName = this.getRepeatedPropertyName(name);
        this.properties.put(propertyName, value);
        return propertyName;
    }

    @Override
    public void exportTestIntegration(TestIntegration testIntegration) {
        this.integrations.add(testIntegration);
    }

    @Override
    public void testSkipped(TestClock.TestInstant now) {
        this.compareAndSetState(State.STARTED, State.SKIPPED, now);
    }

    @Override
    public void testSuppressed(TestClock.TestInstant now) {
        this.compareAndSetState(INITIAL_STATES, State.SUPPRESSED, now);
    }

    public void finished(TestClock.TestInstant now) {
        this.compareAndSetState(State.STARTED, State.FINISHED, now);
    }

    @Override
    public void testFailure(Throwable throwable, TestClock.TestInstant now) {
        this.compareAndSetState(INITIAL_STATES, State.FINISHED, now);
        this.globalFailures.add(throwable);
    }

    @Override
    public void dynamicTestFailure(Description test, Throwable throwable, TestClock.TestInstant now) {
        this.compareAndSetState(INITIAL_STATES, State.FINISHED, now);
        this.addThrowableToDynamicTestToFailures(test, throwable);
    }

    private String getRepeatedPropertyName(String name) {
        int index = this.addNameToRepeatedPropertyNamesAndGetRepetitionsNr(name) + 1000;
        return name + index;
    }

    @Override
    public boolean isTestCase() {
        return true;
    }

    private synchronized void addThrowableToDynamicTestToFailures(Description test, Throwable throwable) {
        ArrayList<Throwable> throwables = (ArrayList<Throwable>)this.dynamicTestToFailures.get(test);
        if (throwables == null) {
            throwables = new ArrayList<Throwable>();
            this.dynamicTestToFailures.put(test, throwables);
        }
        throwables.add(throwable);
    }

    private synchronized int addNameToRepeatedPropertyNamesAndGetRepetitionsNr(String name) {
        Integer previousRepetitionsNr = this.repeatedPropertyNamesToRepetitions.get(name);
        if (previousRepetitionsNr == null) {
            previousRepetitionsNr = 0;
        }
        this.repeatedPropertyNamesToRepetitions.put(name, previousRepetitionsNr + 1);
        return previousRepetitionsNr;
    }

    private boolean compareAndSetState(State fromState, State toState, TestClock.TestInstant now) {
        if (fromState == null) {
            throw new NullPointerException();
        }
        return this.compareAndSetState(Collections.singleton(fromState), toState, now);
    }

    private synchronized boolean compareAndSetState(Set<State> fromStates, State toState, TestClock.TestInstant now) {
        if (fromStates == null || toState == null || this.state == null) {
            throw new NullPointerException();
        }
        if (fromStates.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (fromStates.contains((Object)this.state) && toState != this.state) {
            this.state = toState;
            if (toState != State.PENDING) {
                this.runTimeInterval = this.runTimeInterval == null ? new TestInterval(now, now) : this.runTimeInterval.withEndMillis(now);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public TestInterval getRuntime() {
        return this.runTimeInterval;
    }

    public TestResult.Status getTestResultStatus() {
        return this.state.getTestResultStatus();
    }

    @Override
    protected TestResult buildResult() {
        String name = this.getDescription().getMethodName();
        String className = this.getDescription().getClassName();
        if (name == null) {
            name = className;
            className = this.parent.getDescription().getDisplayName();
        }
        ArrayList<TestResult> childResults = new ArrayList<TestResult>();
        for (Description dynamicTest : this.getDescription().getChildren()) {
            childResults.add(this.buildDynamicResult(dynamicTest, this.getRuntime(), this.getTestResultStatus()));
        }
        int numTests = this.getDescription().isTest() ? 1 : this.getDescription().getChildren().size();
        int numFailures = this.globalFailures.isEmpty() ? this.dynamicTestToFailures.keySet().size() : numTests;
        return new TestResult.Builder().name(name).className(className).properties(this.properties).failures(new ArrayList<Throwable>(this.globalFailures)).runTimeInterval(this.getRuntime()).status(this.getTestResultStatus()).numTests(numTests).numFailures(numFailures).childResults(childResults).integrations(this.integrations).build();
    }

    private TestResult buildDynamicResult(Description test, @Nullable TestInterval runTime, TestResult.Status status) {
        ArrayList<Throwable> dynamicFailures = (ArrayList<Throwable>)this.dynamicTestToFailures.get(test);
        if (dynamicFailures == null) {
            dynamicFailures = new ArrayList<Throwable>();
        }
        boolean failed = !this.globalFailures.isEmpty() || !dynamicFailures.isEmpty();
        return new TestResult.Builder().name(test.getDisplayName()).className(this.getDescription().getDisplayName()).properties(Collections.emptyMap()).failures(dynamicFailures).runTimeInterval(runTime).status(status).numTests(1).numFailures(failed ? 1 : 0).childResults(Collections.emptyList()).integrations(Collections.emptySet()).build();
    }

    private static enum State {
        INITIAL(TestResult.Status.FILTERED),
        PENDING(TestResult.Status.CANCELLED),
        STARTED(TestResult.Status.INTERRUPTED),
        SKIPPED(TestResult.Status.SKIPPED),
        SUPPRESSED(TestResult.Status.SUPPRESSED),
        CANCELLED(TestResult.Status.CANCELLED),
        INTERRUPTED(TestResult.Status.INTERRUPTED),
        FINISHED(TestResult.Status.COMPLETED);

        private final TestResult.Status status;

        private State(TestResult.Status status) {
            this.status = status;
        }

        public TestResult.Status getTestResultStatus() {
            return this.status;
        }
    }
}

