/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.model;

import com.google.testing.junit.runner.model.TestInterval;
import com.google.testing.junit.runner.model.TestResult;
import com.google.testing.junit.runner.model.XmlResultWriter;
import com.google.testing.junit.runner.model.XmlWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class AntXmlResultWriter
implements XmlResultWriter {
    private static final String JUNIT_ELEMENT_TESTSUITES = "testsuites";
    private static final String JUNIT_ELEMENT_TESTSUITE = "testsuite";
    private static final String JUNIT_ELEMENT_TESTSUITE_PROPERTIES = "properties";
    private static final String JUNIT_ELEMENT_TESTSUITE_SYSTEM_OUT = "system-out";
    private static final String JUNIT_ELEMENT_TESTSUITE_SYSTEM_ERR = "system-err";
    private static final String JUNIT_ELEMENT_PROPERTY = "property";
    private static final String JUNIT_ELEMENT_TESTCASE = "testcase";
    private static final String JUNIT_ELEMENT_FAILURE = "failure";
    private static final String JUNIT_ELEMENT_SKIPPED = "skipped";
    private static final String JUNIT_ATTR_TESTSUITE_ERRORS = "errors";
    private static final String JUNIT_ATTR_TESTSUITE_FAILURES = "failures";
    private static final String JUNIT_ATTR_TESTSUITE_HOSTNAME = "hostname";
    private static final String JUNIT_ATTR_TESTSUITE_NAME = "name";
    private static final String JUNIT_ATTR_TESTSUITE_TESTS = "tests";
    private static final String JUNIT_ATTR_TESTSUITE_TIME = "time";
    private static final String JUNIT_ATTR_TESTSUITE_TIMESTAMP = "timestamp";
    private static final String JUNIT_ATTR_TESTSUITE_ID = "id";
    private static final String JUNIT_ATTR_TESTSUITE_PACKAGE = "package";
    private static final String JUNIT_ATTR_PROPERTY_NAME = "name";
    private static final String JUNIT_ATTR_PROPERTY_VALUE = "value";
    private static final String JUNIT_ATTR_FAILURE_MESSAGE = "message";
    private static final String JUNIT_ATTR_FAILURE_TYPE = "type";
    private static final String JUNIT_ATTR_TESTCASE_NAME = "name";
    private static final String JUNIT_ATTR_TESTCASE_CLASSNAME = "classname";
    private static final String JUNIT_ATTR_TESTCASE_TIME = "time";
    private int testSuiteId;

    @Inject
    public AntXmlResultWriter() {
    }

    @Override
    public void writeTestSuites(XmlWriter writer, TestResult result) throws IOException {
        this.testSuiteId = 0;
        writer.startDocument();
        writer.startElement(JUNIT_ELEMENT_TESTSUITES);
        for (TestResult child : result.getChildResults()) {
            this.writeTestSuite(writer, child, result.getFailures());
        }
        writer.endElement();
        writer.close();
    }

    private void writeTestSuite(XmlWriter writer, TestResult result, Iterable<Throwable> parentFailures) throws IOException {
        ArrayList<Throwable> allFailures = new ArrayList<Throwable>();
        for (Throwable failure : parentFailures) {
            allFailures.add(failure);
        }
        allFailures.addAll(result.getFailures());
        parentFailures = allFailures;
        writer.startElement(JUNIT_ELEMENT_TESTSUITE);
        this.writeTestSuiteAttributes(writer, result);
        this.writeTestSuiteProperties(writer, result);
        this.writeTestCases(writer, result, parentFailures);
        this.writeTestSuiteOutput(writer);
        writer.endElement();
        for (TestResult child : result.getChildResults()) {
            if (child.getChildResults().isEmpty()) continue;
            this.writeTestSuite(writer, child, parentFailures);
        }
    }

    private void writeTestSuiteProperties(XmlWriter writer, TestResult result) throws IOException {
        writer.startElement(JUNIT_ELEMENT_TESTSUITE_PROPERTIES);
        for (Map.Entry<String, String> entry : result.getProperties().entrySet()) {
            writer.startElement(JUNIT_ELEMENT_PROPERTY);
            writer.writeAttribute("name", entry.getKey());
            writer.writeAttribute(JUNIT_ATTR_PROPERTY_VALUE, entry.getValue());
            writer.endElement();
        }
        writer.endElement();
    }

    private void writeTestCases(XmlWriter writer, TestResult result, Iterable<Throwable> parentFailures) throws IOException {
        for (TestResult child : result.getChildResults()) {
            if (child.getStatus().equals((Object)TestResult.Status.FILTERED) || !child.getChildResults().isEmpty()) continue;
            this.writeTestCase(writer, child, parentFailures);
        }
    }

    private void writeTestSuiteOutput(XmlWriter writer) throws IOException {
        writer.startElement(JUNIT_ELEMENT_TESTSUITE_SYSTEM_OUT);
        writer.endElement();
        writer.startElement(JUNIT_ELEMENT_TESTSUITE_SYSTEM_ERR);
        writer.endElement();
    }

    private void writeTestSuiteAttributes(XmlWriter writer, TestResult result) throws IOException {
        writer.writeAttribute("name", result.getName());
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_TIMESTAMP, AntXmlResultWriter.getFormattedTimestamp(result.getRunTimeInterval()));
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_HOSTNAME, "localhost");
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_TESTS, result.getNumTests());
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_FAILURES, result.getNumFailures());
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_ERRORS, 0);
        writer.writeAttribute("time", AntXmlResultWriter.getFormattedRunTime(result.getRunTimeInterval()));
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_PACKAGE, "");
        writer.writeAttribute(JUNIT_ATTR_TESTSUITE_ID, this.testSuiteId++);
    }

    private static String getFormattedRunTime(@Nullable TestInterval runTimeInterval) {
        return runTimeInterval == null ? "0.0" : String.valueOf((double)runTimeInterval.toDurationMillis() / 1000.0);
    }

    private static String getFormattedTimestamp(@Nullable TestInterval runTimeInterval) {
        return runTimeInterval == null ? "" : runTimeInterval.startInstantToString();
    }

    private void writeTestCase(XmlWriter writer, TestResult result, Iterable<Throwable> parentFailures) throws IOException {
        writer.startElement(JUNIT_ELEMENT_TESTCASE);
        writer.writeAttribute("name", result.getName());
        writer.writeAttribute(JUNIT_ATTR_TESTCASE_CLASSNAME, result.getClassName());
        writer.writeAttribute("time", AntXmlResultWriter.getFormattedRunTime(result.getRunTimeInterval()));
        for (Throwable failure : parentFailures) {
            AntXmlResultWriter.writeThrowableToXmlWriter(writer, failure);
        }
        for (Throwable failure : result.getFailures()) {
            AntXmlResultWriter.writeThrowableToXmlWriter(writer, failure);
        }
        if (result.getStatus().equals((Object)TestResult.Status.SKIPPED) || result.getStatus().equals((Object)TestResult.Status.SUPPRESSED)) {
            writer.startElement(JUNIT_ELEMENT_SKIPPED);
            writer.endElement();
        }
        writer.endElement();
    }

    private static void writeThrowableToXmlWriter(XmlWriter writer, Throwable failure) throws IOException {
        writer.startElement(JUNIT_ELEMENT_FAILURE);
        writer.writeAttribute(JUNIT_ATTR_FAILURE_MESSAGE, failure.getMessage() == null ? "" : failure.getMessage());
        writer.writeAttribute(JUNIT_ATTR_FAILURE_TYPE, failure.getClass().getName());
        writer.writeCharacters(AntXmlResultWriter.formatStackTrace(failure));
        writer.endElement();
    }

    private static String formatStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        throwable.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }
}

