/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.runner.junit4.JUnit4Config;
import com.google.testing.junit.runner.junit4.JUnit4RunnerModule;
import com.google.testing.junit.runner.util.Factory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;

public final class ProvideXmlStreamFactory
implements Factory<OutputStream> {
    private final Supplier<JUnit4Config> configSupplier;

    public ProvideXmlStreamFactory(Supplier<JUnit4Config> configSupplier) {
        if (configSupplier == null) {
            throw new IllegalStateException();
        }
        this.configSupplier = configSupplier;
    }

    @Override
    public OutputStream get() {
        return new LazyOutputStream(() -> JUnit4RunnerModule.provideXmlStream(this.configSupplier.get()));
    }

    public static Factory<OutputStream> create(Supplier<JUnit4Config> configSupplier) {
        return new ProvideXmlStreamFactory(configSupplier);
    }

    private static class LazyOutputStream
    extends OutputStream {
        private Supplier<OutputStream> supplier;
        private volatile OutputStream delegate;

        public LazyOutputStream(Supplier<OutputStream> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream ensureDelegate() {
            OutputStream delegate0 = this.delegate;
            if (delegate0 != null) {
                return delegate0;
            }
            LazyOutputStream lazyOutputStream = this;
            synchronized (lazyOutputStream) {
                if (this.delegate == null) {
                    this.delegate = this.supplier.get();
                    this.supplier = null;
                }
            }
            return this.delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureDelegate().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureDelegate().write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.ensureDelegate().write(b);
        }

        @Override
        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.delegate != null) {
                this.delegate.flush();
            }
        }
    }
}

