/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.runner.junit4.TopLevelSuite;
import com.google.testing.junit.runner.model.TestSuiteModel;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.runner.Description;
import org.junit.runner.Request;

@Singleton
class JUnit4TestModelBuilder
implements Supplier<TestSuiteModel> {
    private final Request request;
    private final String suiteName;
    private final TestSuiteModel.Builder builder;

    @Inject
    public JUnit4TestModelBuilder(Request request, @TopLevelSuite String suiteName, TestSuiteModel.Builder builder) {
        this.request = request;
        this.suiteName = suiteName;
        this.builder = builder;
    }

    @Override
    public TestSuiteModel get() {
        Description root = this.request.getRunner().getDescription();
        if (!root.isSuite()) {
            return this.builder.build(this.suiteName, new Description[0]);
        }
        return this.builder.build(this.suiteName, root);
    }
}

