/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.runner.internal.SignalHandlers;
import com.google.testing.junit.runner.internal.Xml;
import com.google.testing.junit.runner.internal.junit4.CancellableRequestFactory;
import com.google.testing.junit.runner.internal.junit4.JUnit4TestNameListener;
import com.google.testing.junit.runner.internal.junit4.JUnit4TestStackTraceListener;
import com.google.testing.junit.runner.internal.junit4.JUnit4TestXmlListener;
import com.google.testing.junit.runner.internal.junit4.SettableCurrentRunningTest;
import com.google.testing.junit.runner.junit4.JUnit4Config;
import com.google.testing.junit.runner.junit4.JUnit4Options;
import com.google.testing.junit.runner.junit4.JUnit4RunnerBaseModule;
import com.google.testing.junit.runner.junit4.ProvideXmlStreamFactory;
import com.google.testing.junit.runner.model.TestSuiteModel;
import com.google.testing.junit.runner.sharding.ShardingEnvironment;
import com.google.testing.junit.runner.sharding.ShardingFilters;
import com.google.testing.junit.runner.util.TestClock;
import com.google.testing.junit.runner.util.TestNameProvider;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.junit.runner.notification.RunListener;

class JUnit4RunnerModule {
    private final JUnit4Options options;

    public JUnit4RunnerModule(JUnit4Options options) {
        this.options = options;
    }

    @Singleton
    @Xml
    static OutputStream provideXmlStream(JUnit4Config config) {
        Path path = config.getXmlOutputPath();
        if (path != null) {
            try {
                return new FileOutputStream(path.toFile());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b) {
                if (b == null) {
                    throw new NullPointerException();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) {
                if (b == null) {
                    throw new NullPointerException();
                }
            }

            public String toString() {
                return "null OutputStream";
            }
        };
    }

    private static SettableCurrentRunningTest provideCurrentRunningTest() {
        return new SettableCurrentRunningTest(){

            @Override
            protected void setGlobalTestNameProvider(TestNameProvider provider) {
                testNameProvider = provider;
            }
        };
    }

    ShardingEnvironment shardingEnvironment() {
        return new ShardingEnvironment();
    }

    ShardingFilters shardingFilters(ShardingEnvironment shardingEnvironment) {
        return new ShardingFilters(shardingEnvironment, ShardingFilters.DEFAULT_SHARDING_STRATEGY);
    }

    PrintStream stdout() {
        return System.out;
    }

    JUnit4Config config() {
        return new JUnit4Config(this.options.getTestRunnerFailFast(), this.options.getTestIncludeFilter(), this.options.getTestExcludeFilter());
    }

    TestClock clock() {
        return TestClock.systemClock();
    }

    Set<RunListener> setOfRunListeners(JUnit4Config config, Supplier<TestSuiteModel> testSuiteModelSupplier, CancellableRequestFactory cancellableRequestFactory) {
        HashSet<RunListener> listeners = new HashSet<RunListener>();
        listeners.add(new JUnit4TestStackTraceListener(new SignalHandlers(SignalHandlers.createRealHandlerInstaller()), System.err));
        listeners.add(new JUnit4TestXmlListener(testSuiteModelSupplier, cancellableRequestFactory, new SignalHandlers(SignalHandlers.createRealHandlerInstaller()), new ProvideXmlStreamFactory(() -> config).get(), System.err));
        listeners.add(new JUnit4TestNameListener(JUnit4RunnerModule.provideCurrentRunningTest()));
        listeners.add(JUnit4RunnerBaseModule.provideTextListener(this.stdout()));
        return Collections.unmodifiableSet(listeners);
    }

    CancellableRequestFactory cancellableRequestFactory() {
        return new CancellableRequestFactory();
    }
}

