/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.runner.internal.Stdout;
import com.google.testing.junit.runner.internal.junit4.MemoizingRequest;
import com.google.testing.junit.runner.junit4.TopLevelSuite;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.inject.Singleton;
import org.junit.internal.TextListener;
import org.junit.runner.Request;

public abstract class JUnit4RunnerBaseModule {
    @Singleton
    static TextListener provideTextListener(@Stdout PrintStream testRunnerOut) {
        return new TextListener(JUnit4RunnerBaseModule.asUtf8PrintStream(testRunnerOut));
    }

    private static PrintStream asUtf8PrintStream(OutputStream stream) {
        try {
            return new PrintStream(stream, false, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 must be supported as per the java language spec", e);
        }
    }

    @Singleton
    static Request provideRequest(@TopLevelSuite Class<?> suiteClass) {
        Request request = Request.aClass(suiteClass);
        return new MemoizingRequest(request);
    }

    private JUnit4RunnerBaseModule() {
    }
}

