/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.junit4.runner.RegExTestCaseFilter;
import com.google.testing.junit.junit4.runner.SuiteTrimmingFilter;
import com.google.testing.junit.runner.internal.Stdout;
import com.google.testing.junit.runner.internal.junit4.CancellableRequestFactory;
import com.google.testing.junit.runner.junit4.JUnit4Config;
import com.google.testing.junit.runner.model.TestSuiteModel;
import com.google.testing.junit.runner.util.GoogleTestSecurityManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnit4Runner {
    private final Request request;
    private final CancellableRequestFactory requestFactory;
    private final Supplier<TestSuiteModel> modelSupplier;
    private final PrintStream testRunnerOut;
    private final JUnit4Config config;
    private final Set<RunListener> runListeners;
    private final Set<Initializer> initializers;
    private GoogleTestSecurityManager googleTestSecurityManager;
    private SecurityManager previousSecurityManager;

    @Inject
    JUnit4Runner(Request request, CancellableRequestFactory requestFactory, Supplier<TestSuiteModel> modelSupplier, @Stdout PrintStream testRunnerOut, JUnit4Config config, Set<RunListener> runListeners, Set<Initializer> initializers) {
        this.request = request;
        this.requestFactory = requestFactory;
        this.modelSupplier = modelSupplier;
        this.config = config;
        this.testRunnerOut = testRunnerOut;
        this.runListeners = runListeners;
        this.initializers = initializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run() {
        this.testRunnerOut.println("JUnit4 Test Runner");
        this.checkJUnitRunnerApiVersion();
        for (Initializer init : this.initializers) {
            init.initialize();
        }
        TestSuiteModel model = this.modelSupplier.get();
        Filter shardingFilter = model.getShardingFilter();
        Request filteredRequest = JUnit4Runner.applyFilters(this.request, shardingFilter, this.config.getTestIncludeFilterRegexp(), this.config.getTestExcludeFilterRegexp());
        JUnitCore core = new JUnitCore();
        for (RunListener runListener : this.runListeners) {
            core.addListener(runListener);
        }
        if (this.config.getTestRunnerFailFast()) {
            core.addListener(new StopOnFailureRunListener(this.requestFactory));
        }
        File exitFile = JUnit4Runner.getExitFile();
        JUnit4Runner.exitFileActive(exitFile);
        try {
            try {
                if (this.config.shouldInstallSecurityManager()) {
                    this.installSecurityManager();
                }
                Request cancellableRequest = this.requestFactory.createRequest(filteredRequest);
                Result result = core.run(cancellableRequest);
                this.disableSecurityManager();
                return result;
            }
            catch (Throwable throwable) {
                this.disableSecurityManager();
                throw throwable;
            }
        }
        finally {
            this.exitFileInactive(exitFile);
        }
    }

    private static File getExitFile() {
        String exitFile = System.getenv("TEST_PREMATURE_EXIT_FILE");
        return exitFile == null ? null : new File(exitFile);
    }

    private static void exitFileActive(@Nullable File file) {
        if (file != null) {
            try (FileOutputStream outputStream = new FileOutputStream(file, false);){
                outputStream.write(new byte[0]);
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write exit file at " + file, e);
            }
        }
    }

    private void exitFileInactive(@Nullable File file) {
        if (file != null) {
            try {
                file.delete();
            }
            catch (Throwable t) {
                t.printStackTrace(this.testRunnerOut);
            }
        }
    }

    TestSuiteModel getModel() {
        return this.modelSupplier.get();
    }

    private static Request applyFilter(Request request, Filter filter) throws NoTestsRemainException {
        Runner runner = request.getRunner();
        new SuiteTrimmingFilter(filter).apply(runner);
        return Request.runner(runner);
    }

    private static Request applyFilters(Request request, Filter shardingFilter, @Nullable String testIncludeFilterRegexp, @Nullable String testExcludeFilterRegexp) {
        boolean allowNoTests = false;
        Filter filter = Filter.ALL;
        if (testIncludeFilterRegexp != null) {
            filter = RegExTestCaseFilter.include(testIncludeFilterRegexp);
        }
        if (testExcludeFilterRegexp != null) {
            RegExTestCaseFilter excludeFilter = RegExTestCaseFilter.exclude(testExcludeFilterRegexp);
            filter = filter.intersect(excludeFilter);
        }
        if (testIncludeFilterRegexp != null || testExcludeFilterRegexp != null) {
            try {
                request = JUnit4Runner.applyFilter(request, filter);
            }
            catch (NoTestsRemainException e) {
                return JUnit4Runner.createErrorReportingRequestForFilterError(filter);
            }
            boolean bl = allowNoTests = shardingFilter != Filter.ALL;
        }
        if (shardingFilter != Filter.ALL) {
            filter = filter.intersect(shardingFilter);
        }
        if (filter != Filter.ALL) {
            try {
                request = JUnit4Runner.applyFilter(request, filter);
            }
            catch (NoTestsRemainException e) {
                if (allowNoTests) {
                    return Request.runner(new NoOpRunner());
                }
                return JUnit4Runner.createErrorReportingRequestForFilterError(filter);
            }
        }
        return request;
    }

    private static Request createErrorReportingRequestForFilterError(Filter filter) {
        ErrorReportingRunner runner = new ErrorReportingRunner(Filter.class, new Exception(String.format("No tests found matching %s", filter.describe())));
        return Request.runner(runner);
    }

    private void checkJUnitRunnerApiVersion() {
        this.config.getJUnitRunnerApiVersion();
    }

    private void installSecurityManager() {
        this.previousSecurityManager = System.getSecurityManager();
        GoogleTestSecurityManager newSecurityManager = new GoogleTestSecurityManager();
        System.setSecurityManager(newSecurityManager);
        this.googleTestSecurityManager = newSecurityManager;
    }

    private void disableSecurityManager() {
        if (this.googleTestSecurityManager != null) {
            GoogleTestSecurityManager.uninstallIfInstalled();
            System.setSecurityManager(this.previousSecurityManager);
        }
    }

    private static class StopOnFailureRunListener
    extends RunListener {
        private final CancellableRequestFactory cancellableRequestFactory;

        public StopOnFailureRunListener(CancellableRequestFactory cancellableRequestFactory) {
            this.cancellableRequestFactory = cancellableRequestFactory;
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            this.cancellableRequestFactory.cancelRunOrderly();
        }
    }

    public static interface Initializer {
        public void initialize();
    }

    static class NoOpRunner
    extends Runner {
        NoOpRunner() {
        }

        @Override
        public Description getDescription() {
            return Description.createTestDescription(this.getClass(), "nothingToDo");
        }

        @Override
        public void run(RunNotifier notifier) {
        }
    }
}

