/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class JUnit4Options {
    public static final String TEST_INCLUDE_FILTER_OPTION = "--test_filter";
    public static final String TEST_EXCLUDE_FILTER_OPTION = "--test_exclude_filter";
    private static final String TESTBRIDGE_TEST_ONLY = "TESTBRIDGE_TEST_ONLY";
    private static final String TESTBRIDGE_TEST_RUNNER_FAIL_FAST = "TESTBRIDGE_TEST_RUNNER_FAIL_FAST";
    private final boolean testRunnerFailFast;
    private final String testIncludeFilter;
    private final String testExcludeFilter;
    private final String[] unparsedArgs;

    static JUnit4Options parse(Map<String, String> envVars, List<String> args) {
        ArrayList<String> unparsedArgs = new ArrayList<String>();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        optionsMap.put(TEST_INCLUDE_FILTER_OPTION, null);
        optionsMap.put(TEST_EXCLUDE_FILTER_OPTION, null);
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String arg = it.next();
            int indexOfEquals = arg.indexOf("=");
            if (indexOfEquals > 0) {
                String optionName = arg.substring(0, indexOfEquals);
                if (optionsMap.containsKey(optionName)) {
                    optionsMap.put(optionName, arg.substring(indexOfEquals + 1));
                    continue;
                }
            } else if (optionsMap.containsKey(arg)) {
                if (!it.hasNext()) {
                    throw new RuntimeException("No filter expression specified after " + arg);
                }
                optionsMap.put(arg, it.next());
                continue;
            }
            unparsedArgs.add(arg);
        }
        String testFilter = envVars.get(TESTBRIDGE_TEST_ONLY);
        if (testFilter != null && optionsMap.get(TEST_INCLUDE_FILTER_OPTION) == null) {
            optionsMap.put(TEST_INCLUDE_FILTER_OPTION, testFilter);
        }
        boolean testRunnerFailFast = "1".equals(envVars.get(TESTBRIDGE_TEST_RUNNER_FAIL_FAST));
        return new JUnit4Options(testRunnerFailFast, (String)optionsMap.get(TEST_INCLUDE_FILTER_OPTION), (String)optionsMap.get(TEST_EXCLUDE_FILTER_OPTION), unparsedArgs.toArray(new String[0]));
    }

    JUnit4Options(boolean testRunnerFailFast, @Nullable String testIncludeFilter, @Nullable String testExcludeFilter, String[] unparsedArgs) {
        this.testRunnerFailFast = testRunnerFailFast;
        this.testIncludeFilter = testIncludeFilter;
        this.testExcludeFilter = testExcludeFilter;
        this.unparsedArgs = unparsedArgs;
    }

    boolean getTestRunnerFailFast() {
        return this.testRunnerFailFast;
    }

    String getTestIncludeFilter() {
        return this.testIncludeFilter;
    }

    String getTestExcludeFilter() {
        return this.testExcludeFilter;
    }

    String[] getUnparsedArgs() {
        return this.unparsedArgs;
    }
}

