/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.Nullable;

class JUnit4Config {
    static final String JUNIT_API_VERSION_PROPERTY = "com.google.testing.junit.runner.apiVersion";
    static final String SHOULD_INSTALL_SECURITY_MANAGER_PROPERTY = "com.google.testing.junit.runner.shouldInstallTestSecurityManager";
    private final boolean testRunnerFailFast;
    private final String testIncludeFilterRegexp;
    private final String testExcludeFilterRegexp;
    @Nullable
    private final Path xmlOutputPath;
    private final String junitApiVersion;
    private final boolean shouldInstallSecurityManager;
    private static final String XML_OUTPUT_FILE_ENV_VAR = "XML_OUTPUT_FILE";

    public JUnit4Config(String testIncludeFilterRegexp, String testExcludeFilterRegexp, @Nullable Path outputXmlFilePath) {
        this(false, testIncludeFilterRegexp, testExcludeFilterRegexp, outputXmlFilePath, System.getProperties());
    }

    public JUnit4Config(boolean testRunnerFailFast, String testIncludeFilterRegexp, String testExcludeFilterRegexp) {
        this(testRunnerFailFast, testIncludeFilterRegexp, testExcludeFilterRegexp, null, System.getProperties());
    }

    JUnit4Config(String testIncludeFilterRegexp, String testExcludeFilterRegexp, @Nullable Path xmlOutputPath, Properties systemProperties) {
        this(false, testIncludeFilterRegexp, testExcludeFilterRegexp, xmlOutputPath, systemProperties);
    }

    private JUnit4Config(boolean testRunnerFailFast, String testIncludeFilterRegexp, String testExcludeFilterRegexp, @Nullable Path xmlOutputPath, Properties systemProperties) {
        this.testRunnerFailFast = testRunnerFailFast;
        this.testIncludeFilterRegexp = testIncludeFilterRegexp;
        this.testExcludeFilterRegexp = testExcludeFilterRegexp;
        this.xmlOutputPath = xmlOutputPath;
        this.junitApiVersion = systemProperties.getProperty(JUNIT_API_VERSION_PROPERTY, "1").trim();
        this.shouldInstallSecurityManager = JUnit4Config.installSecurityManager(systemProperties);
    }

    private static boolean installSecurityManager(Properties systemProperties) {
        String securityManager = systemProperties.getProperty("java.security.manager");
        if (securityManager != null && !securityManager.equals("allow")) {
            return false;
        }
        return Boolean.valueOf(systemProperties.getProperty(SHOULD_INSTALL_SECURITY_MANAGER_PROPERTY, "true"));
    }

    public boolean shouldInstallSecurityManager() {
        return this.shouldInstallSecurityManager;
    }

    @Nullable
    public Path getXmlOutputPath() {
        if (this.xmlOutputPath == null) {
            String envXmlOutputPath = System.getenv(XML_OUTPUT_FILE_ENV_VAR);
            return envXmlOutputPath == null ? null : FileSystems.getDefault().getPath(envXmlOutputPath, new String[0]);
        }
        return this.xmlOutputPath;
    }

    public int getJUnitRunnerApiVersion() {
        int apiVersion = 0;
        try {
            apiVersion = Integer.parseInt(this.junitApiVersion);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (apiVersion != 1) {
            throw new IllegalStateException("Unsupported JUnit Runner API version com.google.testing.junit.runner.apiVersion=" + this.junitApiVersion + " (must be \\\"1\\\")");
        }
        return apiVersion;
    }

    boolean getTestRunnerFailFast() {
        return this.testRunnerFailFast;
    }

    public String getTestIncludeFilterRegexp() {
        return this.testIncludeFilterRegexp;
    }

    public String getTestExcludeFilterRegexp() {
        return this.testExcludeFilterRegexp;
    }
}

