/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.junit4;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.junit.runner.internal.junit4.CancellableRequestFactory;
import com.google.testing.junit.runner.junit4.JUnit4Config;
import com.google.testing.junit.runner.junit4.JUnit4InstanceModules;
import com.google.testing.junit.runner.junit4.JUnit4Runner;
import com.google.testing.junit.runner.junit4.JUnit4RunnerBaseModule;
import com.google.testing.junit.runner.junit4.JUnit4RunnerModule;
import com.google.testing.junit.runner.junit4.JUnit4TestModelBuilder;
import com.google.testing.junit.runner.model.AntXmlResultWriter;
import com.google.testing.junit.runner.model.TestSuiteModel;
import com.google.testing.junit.runner.sharding.ShardingEnvironment;
import com.google.testing.junit.runner.sharding.ShardingFilters;
import com.google.testing.junit.runner.util.MemoizingSupplier;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public final class JUnit4Bazel {
    private Request request;
    private CancellableRequestFactory cancellableRequestFactory;
    private JUnit4TestModelBuilder jUnit4TestModelBuilder;
    private Supplier<TestSuiteModel> testSuiteModelSupplier;
    private PrintStream stdoutStream;
    private JUnit4Config config;
    private Set<RunListener> setOfRunListeners;

    JUnit4Bazel(Builder<?> builder) {
        this.initialize(JUnit4Bazel.checkNotNull(builder));
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    private void initialize(Builder<?> builder) {
        Class topLevelSuite = ((Builder)builder).suiteClass;
        this.request = JUnit4RunnerBaseModule.provideRequest(topLevelSuite);
        this.cancellableRequestFactory = builder.module.cancellableRequestFactory();
        String topLevelSuiteName = topLevelSuite.getCanonicalName();
        ShardingEnvironment shardingEnvironment = builder.module.shardingEnvironment();
        ShardingFilters shardingFilters = builder.module.shardingFilters(shardingEnvironment);
        AntXmlResultWriter resultWriter = new AntXmlResultWriter();
        TestSuiteModel.Builder builder1 = new TestSuiteModel.Builder(builder.module.clock(), shardingFilters, shardingEnvironment, resultWriter);
        this.jUnit4TestModelBuilder = new JUnit4TestModelBuilder(this.request, topLevelSuiteName, builder1);
        this.testSuiteModelSupplier = new MemoizingSupplier<TestSuiteModel>(() -> this.jUnit4TestModelBuilder.get());
        this.stdoutStream = builder.module.stdout();
        this.config = builder.module.config();
        this.setOfRunListeners = builder.module.setOfRunListeners(this.config, this.testSuiteModelSupplier, this.cancellableRequestFactory);
    }

    public JUnit4Runner runner() {
        return new JUnit4Runner(this.request, this.cancellableRequestFactory, this.testSuiteModelSupplier, this.stdoutStream, this.config, this.setOfRunListeners, Collections.emptySet());
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static class Builder<B extends Builder<B>> {
        private Class<?> suiteClass;
        private JUnit4InstanceModules.Config config;
        protected JUnit4RunnerModule module;

        public JUnit4Bazel build() {
            if (this.suiteClass == null) {
                throw new IllegalStateException("suiteClass must be set");
            }
            if (this.module == null) {
                this.module = this.createModule();
            }
            return new JUnit4Bazel(this);
        }

        private JUnit4RunnerModule createModule() {
            if (this.config == null) {
                throw new IllegalStateException(JUnit4InstanceModules.Config.class.getCanonicalName() + " must be set");
            }
            return new JUnit4RunnerModule(this.config.options());
        }

        @CanIgnoreReturnValue
        public B suiteClass(Class<?> suiteClass) {
            this.suiteClass = (Class)JUnit4Bazel.checkNotNull(suiteClass);
            return (B)this;
        }

        @CanIgnoreReturnValue
        public B config(JUnit4InstanceModules.Config config) {
            this.config = (JUnit4InstanceModules.Config)JUnit4Bazel.checkNotNull(config);
            return (B)this;
        }
    }
}

