/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal.junit4;

import com.google.testing.junit.runner.internal.SignalHandlers;
import com.google.testing.junit.runner.internal.Stderr;
import com.google.testing.junit.runner.internal.Xml;
import com.google.testing.junit.runner.internal.junit4.CancellableRequestFactory;
import com.google.testing.junit.runner.model.TestSuiteModel;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@Singleton
public class JUnit4TestXmlListener
extends RunListener {
    private final Supplier<TestSuiteModel> modelSupplier;
    private final CancellableRequestFactory requestFactory;
    private final SignalHandlers signalHandlers;
    private final OutputStream xmlStream;
    private final PrintStream errPrintStream;
    private volatile TestSuiteModel model;

    @Inject
    public JUnit4TestXmlListener(Supplier<TestSuiteModel> modelSupplier, CancellableRequestFactory requestFactory, SignalHandlers signalHandlers, @Xml OutputStream xmlStream, @Stderr PrintStream errPrintStream) {
        this.modelSupplier = modelSupplier;
        this.requestFactory = requestFactory;
        this.signalHandlers = signalHandlers;
        this.xmlStream = xmlStream;
        this.errPrintStream = errPrintStream;
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        this.model = this.modelSupplier.get();
        this.model.testRunStarted(description);
        this.signalHandlers.installHandler(new Signal("TERM"), new WriteXmlSignalHandler());
    }

    @Override
    public void testStarted(Description description) throws Exception {
        this.model.testStarted(description);
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        this.model.testSkipped(failure.getDescription());
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        this.model.testFailure(failure.getDescription(), failure.getException());
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        if (this.isSuiteAssumptionFailure(description)) {
            this.model.testSkipped(description);
        } else {
            this.model.testSuppressed(description);
        }
    }

    private boolean isSuiteAssumptionFailure(Description description) {
        return description.isSuite() && description.getAnnotation(Ignore.class) == null;
    }

    @Override
    public void testFinished(Description description) throws Exception {
        this.model.testFinished(description);
    }

    @Override
    public void testRunFinished(Result result) throws Exception {
        this.model.writeAsXml(this.xmlStream);
    }

    private class WriteXmlSignalHandler
    implements SignalHandler {
        private WriteXmlSignalHandler() {
        }

        @Override
        public void handle(Signal signal) {
            try {
                JUnit4TestXmlListener.this.errPrintStream.printf("%nReceived %s; writing test XML%n", signal.toString());
                JUnit4TestXmlListener.this.requestFactory.cancelRun();
                JUnit4TestXmlListener.this.model.testRunInterrupted();
                JUnit4TestXmlListener.this.model.writeAsXml(JUnit4TestXmlListener.this.xmlStream);
                JUnit4TestXmlListener.this.errPrintStream.println("Done writing test XML");
            }
            catch (Exception e) {
                JUnit4TestXmlListener.this.errPrintStream.println("Could not write test XML");
                e.printStackTrace(JUnit4TestXmlListener.this.errPrintStream);
            }
        }
    }
}

