/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal.junit4;

import com.google.testing.junit.runner.internal.SignalHandlers;
import com.google.testing.junit.runner.internal.StackTraces;
import com.google.testing.junit.runner.internal.Stderr;
import java.io.PrintStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@Singleton
public class JUnit4TestStackTraceListener
extends RunListener {
    private final SignalHandlers signalHandlers;
    private final PrintStream errPrintStream;

    @Inject
    public JUnit4TestStackTraceListener(SignalHandlers signalHandlers, @Stderr PrintStream errPrintStream) {
        this.signalHandlers = signalHandlers;
        this.errPrintStream = errPrintStream;
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        this.signalHandlers.installHandler(new Signal("TERM"), new WriteStackTraceSignalHandler());
    }

    private class WriteStackTraceSignalHandler
    implements SignalHandler {
        private WriteStackTraceSignalHandler() {
        }

        @Override
        public void handle(Signal signal) {
            JUnit4TestStackTraceListener.this.errPrintStream.println("Dumping stack traces for all threads\n");
            StackTraces.printAll(JUnit4TestStackTraceListener.this.errPrintStream);
        }
    }
}

