/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal.junit4;

import com.google.testing.junit.runner.internal.junit4.SettableCurrentRunningTest;
import com.google.testing.junit.runner.util.TestNameProvider;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

@Singleton
public class JUnit4TestNameListener
extends RunListener {
    private final ThreadLocal<Description> runningTest = new ThreadLocal();
    private final SettableCurrentRunningTest currentRunningTest;

    @Inject
    public JUnit4TestNameListener(SettableCurrentRunningTest currentRunningTest) {
        this.currentRunningTest = currentRunningTest;
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        this.currentRunningTest.setGlobalTestNameProvider(new TestNameProvider(){

            @Override
            public Description get() {
                return (Description)JUnit4TestNameListener.this.runningTest.get();
            }
        });
    }

    @Override
    public void testStarted(Description description) throws Exception {
        this.runningTest.set(description);
    }

    @Override
    public void testFinished(Description description) throws Exception {
        this.runningTest.set(null);
    }
}

