/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal.junit4;

import com.google.testing.junit.junit4.runner.RunNotifierWrapper;
import com.google.testing.junit.runner.internal.junit4.MemoizingRequest;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

@Singleton
public class CancellableRequestFactory {
    private boolean requestCreated;
    private volatile ThreadSafeRunNotifier currentNotifier;
    private final AtomicReference<CancellationRequest> cancellationRequest = new AtomicReference<CancellationRequest>(CancellationRequest.NOT_REQUESTED);

    @Inject
    public CancellableRequestFactory() {
    }

    public Request createRequest(Request delegate) {
        if (this.requestCreated) {
            throw new IllegalStateException("a request was already created");
        }
        this.requestCreated = true;
        return new MemoizingRequest(delegate){

            @Override
            Runner createRunner(Request delegate) {
                return new CancellableRunner(delegate.getRunner());
            }
        };
    }

    public void cancelRun() {
        this.stop(true);
    }

    public void cancelRunOrderly() {
        this.stop(false);
    }

    private void stop(boolean hardStop) {
        ThreadSafeRunNotifier notifier;
        if (this.cancellationRequest.compareAndSet(CancellationRequest.NOT_REQUESTED, hardStop ? CancellationRequest.HARD_STOP : CancellationRequest.ORDERLY_STOP) && (notifier = this.currentNotifier) != null) {
            ((RunNotifier)notifier).pleaseStop();
        }
    }

    static enum CancellationRequest {
        NOT_REQUESTED,
        HARD_STOP,
        ORDERLY_STOP;

    }

    private static class ThreadSafeRunNotifier
    extends RunNotifierWrapper {
        private volatile boolean stopRequested;

        public ThreadSafeRunNotifier(RunNotifier delegate) {
            super(delegate);
        }

        @Override
        public void fireTestStarted(Description description) throws StoppedByUserException {
            if (this.stopRequested) {
                throw new StoppedByUserException();
            }
            this.getDelegate().fireTestStarted(description);
        }

        @Override
        public void pleaseStop() {
            this.stopRequested = true;
        }
    }

    private class CancellableRunner
    extends Runner {
        private final Runner delegate;

        public CancellableRunner(Runner delegate) {
            this.delegate = delegate;
        }

        @Override
        public Description getDescription() {
            return this.delegate.getDescription();
        }

        @Override
        public void run(RunNotifier notifier) {
            CancellableRequestFactory.this.currentNotifier = new ThreadSafeRunNotifier(notifier);
            if (CancellableRequestFactory.this.cancellationRequest.get() != CancellationRequest.NOT_REQUESTED) {
                CancellableRequestFactory.this.currentNotifier.pleaseStop();
            }
            if (CancellableRequestFactory.this.cancellationRequest.get() == CancellationRequest.ORDERLY_STOP) {
                return;
            }
            try {
                this.delegate.run(CancellableRequestFactory.this.currentNotifier);
            }
            catch (StoppedByUserException e) {
                if (CancellableRequestFactory.this.cancellationRequest.get() == CancellationRequest.HARD_STOP) {
                    throw new RuntimeException("Test run interrupted", e);
                }
                if (CancellableRequestFactory.this.cancellationRequest.get() == CancellationRequest.ORDERLY_STOP) {
                    e.printStackTrace();
                    return;
                }
                throw e;
            }
        }
    }
}

