/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal;

import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;

public class StackTraces {
    public static void printAll(PrintStream out) {
        long[] monitorDeadlockedThreads;
        Thread thread;
        out.println("Starting full thread dump ...\n");
        ThreadMXBean mb = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = mb.dumpAllThreads(true, true);
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        HashMap<Long, Thread> threadMap = new HashMap<Long, Thread>();
        for (Thread thread2 : threads) {
            threadMap.put(thread2.getId(), thread2);
        }
        for (ThreadInfo threadInfo : threadInfos) {
            thread = (Thread)threadMap.get(threadInfo.getThreadId());
            if (thread == null || thread.isDaemon()) continue;
            StackTraces.dumpThreadInfo(threadInfo, thread, out);
        }
        for (ThreadInfo threadInfo : threadInfos) {
            thread = (Thread)threadMap.get(threadInfo.getThreadId());
            if (thread == null || !thread.isDaemon()) continue;
            StackTraces.dumpThreadInfo(threadInfo, thread, out);
        }
        long[] deadlockedThreads = mb.findDeadlockedThreads();
        if (deadlockedThreads != null) {
            out.println("Detected deadlocked threads: " + Arrays.toString(deadlockedThreads));
        }
        if ((monitorDeadlockedThreads = mb.findMonitorDeadlockedThreads()) != null) {
            out.println("Detected monitor deadlocked threads: " + Arrays.toString(monitorDeadlockedThreads));
        }
        out.println("\nDone full thread dump.");
        out.flush();
    }

    private static void dumpThreadInfo(ThreadInfo t, Thread thread, PrintStream out) {
        out.print("\"" + t.getThreadName() + "\" Id=" + t.getThreadId() + " " + (Object)((Object)t.getThreadState()));
        if (t.getLockName() != null) {
            out.print(" on " + t.getLockName());
        }
        if (t.getLockOwnerName() != null) {
            out.print(" owned by \"" + t.getLockOwnerName() + "\" Id=" + t.getLockOwnerId());
        }
        if (t.isSuspended()) {
            out.print(" (suspended)");
        }
        if (t.isInNative()) {
            out.print(" (in native)");
        }
        if (thread.isDaemon()) {
            out.print(" (daemon)");
        }
        out.print('\n');
        StackTraceElement[] stackTrace = t.getStackTrace();
        MonitorInfo[] lockedMonitors = t.getLockedMonitors();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            out.print("\tat " + ste.toString());
            out.print('\n');
            if (i == 0 && t.getLockInfo() != null) {
                Thread.State ts = t.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        out.print("\t-  blocked on " + t.getLockInfo());
                        out.print('\n');
                        break;
                    }
                    case WAITING: {
                        out.print("\t-  waiting on " + t.getLockInfo());
                        out.print('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        out.print("\t-  waiting on " + t.getLockInfo());
                        out.print('\n');
                        break;
                    }
                }
            }
            MonitorInfo[] monitorInfoArray = lockedMonitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo mi = monitorInfoArray[j];
                if (mi.getLockedStackDepth() != i) continue;
                out.print("\t-  locked " + mi);
                out.print('\n');
            }
        }
        LockInfo[] locks = t.getLockedSynchronizers();
        if (locks.length > 0) {
            out.print("\n\tNumber of locked synchronizers = " + locks.length);
            out.print('\n');
            for (LockInfo li : locks) {
                out.print("\t- " + li);
                out.print('\n');
            }
        }
        out.print('\n');
    }
}

