/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner.internal;

import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SignalHandlers {
    private final HandlerInstaller handlerInstaller;

    public static HandlerInstaller createRealHandlerInstaller() {
        return new HandlerInstaller(){

            @Override
            public SignalHandler install(Signal signal, SignalHandler handler) {
                return Signal.handle(signal, handler);
            }
        };
    }

    @Inject
    public SignalHandlers(HandlerInstaller installer) {
        this.handlerInstaller = installer;
    }

    public void installHandler(Signal signal, final SignalHandler signalHandler) {
        final AtomicReference<SignalHandler> previousHandlerReference = new AtomicReference<SignalHandler>();
        previousHandlerReference.set(this.handlerInstaller.install(signal, new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                signalHandler.handle(signal);
                SignalHandler previousHandler = (SignalHandler)previousHandlerReference.get();
                if (previousHandler != null) {
                    previousHandler.handle(signal);
                }
            }
        }));
    }

    public static interface HandlerInstaller {
        public SignalHandler install(Signal var1, SignalHandler var2);
    }
}

