/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.runner;

import com.google.testing.junit.runner.internal.StackTraces;
import com.google.testing.junit.runner.junit4.JUnit4Bazel;
import com.google.testing.junit.runner.junit4.JUnit4InstanceModules;
import com.google.testing.junit.runner.junit4.JUnit4Runner;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class BazelTestRunner {
    static final String TEST_SUITE_PROPERTY_NAME = "bazel.test_suite";

    private BazelTestRunner() {
    }

    public static void main(String[] args) {
        int exitCode;
        PrintStream stderr = System.err;
        String suiteClassName = System.getProperty(TEST_SUITE_PROPERTY_NAME);
        if (!BazelTestRunner.checkTestSuiteProperty(suiteClassName)) {
            System.exit(2);
        }
        try {
            exitCode = BazelTestRunner.runTestsInSuite(suiteClassName, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            exitCode = 1;
        }
        System.err.printf("%nBazelTestRunner exiting with a return value of %d%n", exitCode);
        System.err.println("JVM shutdown hooks (if any) will run now.");
        System.err.println("The JVM will exit once they complete.");
        System.err.println();
        BazelTestRunner.printStackTracesIfJvmExitHangs(stderr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        Date shutdownTime = new Date();
        String formattedShutdownTime = format.format(shutdownTime);
        System.err.printf("-- JVM shutdown starting at %s --%n%n", formattedShutdownTime);
        System.exit(exitCode);
    }

    private static boolean checkTestSuiteProperty(String testSuiteProperty) {
        if (testSuiteProperty == null) {
            System.err.printf("Error: The test suite Java system property %s is required but missing.%n", TEST_SUITE_PROPERTY_NAME);
            System.err.println();
            System.err.println("This property is set automatically when running with Bazel like such:");
            System.err.printf("  java -D%s=[test-suite-class] %s%n", TEST_SUITE_PROPERTY_NAME, BazelTestRunner.class.getName());
            System.err.printf("  java -D%s=[test-suite-class] -jar [deploy-jar]%n", TEST_SUITE_PROPERTY_NAME);
            System.err.println("E.g.:");
            System.err.printf("  java -D%s=org.example.testing.junit.runner.SmallTests %s%n", TEST_SUITE_PROPERTY_NAME, BazelTestRunner.class.getName());
            System.err.printf("  java -D%s=org.example.testing.junit.runner.SmallTests -jar SmallTests_deploy.jar%n", TEST_SUITE_PROPERTY_NAME);
            return false;
        }
        return true;
    }

    private static int runTestsInSuite(String suiteClassName, String[] args) {
        Class<?> suite = BazelTestRunner.getTestClass(suiteClassName);
        if (suite == null && args.length == 0 && suiteClassName != null) {
            System.err.printf("Class not found: [%s]%n", suiteClassName);
            return 2;
        }
        JUnit4Runner runner = ((JUnit4Bazel.Builder)((JUnit4Bazel.Builder)JUnit4Bazel.builder().suiteClass(suite)).config(new JUnit4InstanceModules.Config(args))).build().runner();
        return runner.run().wasSuccessful() ? 0 : 1;
    }

    private static Class<?> getTestClass(String name) {
        if (name == null) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static void printStackTracesIfJvmExitHangs(final PrintStream out) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BazelTestRunner.sleepUninterruptibly(5L);
                out.println("JVM still up after five seconds. Dumping stack traces for all threads.");
                StackTraces.printAll(out);
            }
        }, "BazelTestRunner: Print stack traces if JVM exit hangs");
        thread.setDaemon(true);
        thread.start();
    }

    private static void sleepUninterruptibly(long sleepForSeconds) {
        boolean interrupted = false;
        try {
            long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(sleepForSeconds);
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(end - System.nanoTime());
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

