/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.junit4.runner;

import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public final class RegExTestCaseFilter
extends Filter {
    private static final String TEST_NAME_FORMAT = "%s#%s";
    private final Pattern pattern;
    private final boolean isNegated;

    public static RegExTestCaseFilter include(String regularExpression) {
        return new RegExTestCaseFilter(regularExpression, false);
    }

    public static RegExTestCaseFilter exclude(String regularExpression) {
        return new RegExTestCaseFilter(regularExpression, true);
    }

    private RegExTestCaseFilter(String regularExpression, boolean isNegated) {
        this.isNegated = isNegated;
        this.pattern = Pattern.compile(regularExpression);
    }

    @Override
    public boolean shouldRun(Description description) {
        if (description.isSuite()) {
            return true;
        }
        boolean match = this.pattern.matcher(RegExTestCaseFilter.formatDescriptionName(description)).find();
        return this.isNegated ? !match : match;
    }

    @Override
    public String describe() {
        return String.format("%sRegEx[%s]", this.isNegated ? "NOT " : "", this.pattern.toString());
    }

    private static String formatDescriptionName(Description description) {
        String className;
        String methodName = description.getMethodName() == null ? "" : description.getMethodName();
        String string = className = description.getClassName() == null ? "" : description.getClassName();
        if (methodName.trim().isEmpty() || className.trim().isEmpty()) {
            return description.getDisplayName();
        }
        return String.format(TEST_NAME_FORMAT, className, methodName);
    }
}

