/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.genclass;

import com.google.devtools.build.buildjar.genclass.GenClassOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;

public class GenClassOptionsParser {
    public static GenClassOptions parse(Iterable<String> args) {
        Iterator<String> it = args.iterator();
        GenClassOptions.Builder builder = GenClassOptions.builder();
        block10: while (it.hasNext()) {
            String arg;
            switch (arg = it.next()) {
                case "--manifest_proto": {
                    builder.setManifest(GenClassOptionsParser.readPath(it));
                    continue block10;
                }
                case "--class_jar": {
                    builder.setClassJar(GenClassOptionsParser.readPath(it));
                    continue block10;
                }
                case "--output_jar": {
                    builder.setOutputJar(GenClassOptionsParser.readPath(it));
                    continue block10;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected argument: '%s' in %s", arg, args));
        }
        return builder.build();
    }

    private static Path readPath(Iterator<String> it) {
        if (!it.hasNext()) {
            throw new IllegalArgumentException(String.format("Expected more arguments", new Object[0]));
        }
        return Paths.get(it.next(), new String[0]);
    }
}

