/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.genclass;

import com.google.common.base.Preconditions;
import java.nio.file.Path;

public final class GenClassOptions {
    private final Path manifest;
    private final Path classJar;
    private final Path outputJar;

    private GenClassOptions(Path manifest, Path classJar, Path outputJar) {
        this.manifest = Preconditions.checkNotNull(manifest);
        this.classJar = Preconditions.checkNotNull(classJar);
        this.outputJar = Preconditions.checkNotNull(outputJar);
    }

    public Path manifest() {
        return this.manifest;
    }

    public Path classJar() {
        return this.classJar;
    }

    public Path outputJar() {
        return this.outputJar;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Path manifest;
        private Path classJar;
        private Path outputJar;

        public void setManifest(Path manifest) {
            this.manifest = manifest;
        }

        public void setClassJar(Path classJar) {
            this.classJar = classJar;
        }

        public void setOutputJar(Path outputJar) {
            this.outputJar = outputJar;
        }

        GenClassOptions build() {
            return new GenClassOptions(this.manifest, this.classJar, this.outputJar);
        }
    }
}

