/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.genclass;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.buildjar.genclass.GenClassOptions;
import com.google.devtools.build.buildjar.genclass.GenClassOptionsParser;
import com.google.devtools.build.buildjar.jarhelper.JarCreator;
import com.google.devtools.build.buildjar.proto.JavaCompilation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class GenClass {
    private static void deleteTree(Path directory) throws IOException {
        if (directory.toFile().exists()) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void main(String[] args) throws IOException {
        GenClassOptions options = GenClassOptionsParser.parse(Arrays.asList(args));
        JavaCompilation.Manifest manifest = GenClass.readManifest(options.manifest());
        Path tempDir = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Files.createDirectories(tempDir, new FileAttribute[0]);
        GenClass.extractGeneratedClasses(options.classJar(), manifest, tempDir);
        GenClass.writeOutputJar(tempDir, options);
        GenClass.deleteTree(tempDir);
    }

    private static JavaCompilation.Manifest readManifest(Path path) throws IOException {
        JavaCompilation.Manifest manifest;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            manifest = JavaCompilation.Manifest.parseFrom(inputStream);
        }
        return manifest;
    }

    @VisibleForTesting
    static ImmutableSet<String> getPrefixes(JavaCompilation.Manifest manifest, Predicate<JavaCompilation.CompilationUnit> p) {
        return manifest.getCompilationUnitList().stream().filter(p).flatMap(unit -> GenClass.getUnitPrefixes(unit)).collect(ImmutableSet.toImmutableSet());
    }

    private static Stream<String> getUnitPrefixes(JavaCompilation.CompilationUnit unit) {
        String pkg = unit.hasPkg() ? unit.getPkg().replace('.', '/') + "/" : "";
        return unit.getTopLevelList().stream().map(toplevel -> pkg + toplevel);
    }

    private static void extractGeneratedClasses(Path classJar, JavaCompilation.Manifest manifest, Path tempDir) throws IOException {
        ImmutableSet<String> generatedFilePrefixes = GenClass.getPrefixes(manifest, unit -> unit.getGeneratedByAnnotationProcessor());
        ImmutableSet<String> userWrittenFilePrefixes = GenClass.getPrefixes(manifest, unit -> !unit.getGeneratedByAnnotationProcessor());
        try (JarFile jar = new JarFile(classJar.toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || !GenClass.prefixesContains(generatedFilePrefixes, className = name.substring(0, name.length() - ".class".length())) && GenClass.prefixesContains(userWrittenFilePrefixes, className)) continue;
                Files.createDirectories(tempDir.resolve(name).getParent(), new FileAttribute[0]);
                Files.copy(jar.getInputStream(entry), tempDir.resolve(name), new CopyOption[0]);
            }
        }
    }

    private static boolean prefixesContains(ImmutableSet<String> prefixes, String className) {
        if (prefixes.contains(className)) {
            return true;
        }
        int i = className.indexOf(36);
        while (i != -1) {
            if (prefixes.contains(className.substring(0, i))) {
                return true;
            }
            i = className.indexOf(36, i + 1);
        }
        return false;
    }

    private static void writeOutputJar(Path tempDir, GenClassOptions options) throws IOException {
        JarCreator output = new JarCreator(options.outputJar().toString());
        output.setCompression(true);
        output.setNormalize(true);
        output.addDirectory(tempDir);
        output.execute();
    }
}

