/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.jarhelper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;

public class JarHelper {
    public static final String MANIFEST_DIR = "META-INF/";
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    public static final long DEFAULT_TIMESTAMP = LocalDateTime.of(2010, 1, 1, 0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    public static final Attributes.Name TARGET_LABEL = new Attributes.Name("Target-Label");
    public static final Attributes.Name INJECTING_RULE_KIND = new Attributes.Name("Injecting-Rule-Kind");
    public static final long MINIMUM_TIMESTAMP_INCREMENT = 2000L;
    protected final Path jarPath;
    protected boolean normalize;
    protected int storageMethod = 8;
    protected boolean verbose = false;
    protected final Set<String> names = new HashSet<String>();

    public JarHelper(Path path) {
        this.jarPath = path;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setCompression(boolean compression) {
        this.storageMethod = compression ? 8 : 0;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private long normalizedTimestamp(String name) {
        if (name.endsWith(".class")) {
            return DEFAULT_TIMESTAMP + 2000L;
        }
        return DEFAULT_TIMESTAMP;
    }

    protected long newEntryTimeMillis(String filename) {
        return this.normalize ? this.normalizedTimestamp(filename) : System.currentTimeMillis();
    }

    protected void writeEntry(JarOutputStream out, String name, byte[] content) throws IOException {
        if (this.names.add(name)) {
            JarEntry entry = new JarEntry(name);
            entry.setTime(this.newEntryTimeMillis(name));
            int size = content.length;
            entry.setSize(size);
            if (size == 0) {
                entry.setMethod(0);
                entry.setCrc(0L);
                out.putNextEntry(entry);
            } else {
                entry.setMethod(this.storageMethod);
                if (this.storageMethod == 0) {
                    CRC32 crc = new CRC32();
                    crc.update(content);
                    entry.setCrc(crc.getValue());
                }
                out.putNextEntry(entry);
                out.write(content);
            }
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeManifestEntry(JarOutputStream out, byte[] content) throws IOException {
        int oldStorageMethod = this.storageMethod;
        if (content.length < 256) {
            this.storageMethod = 0;
        }
        try {
            this.writeEntry(out, MANIFEST_DIR, new byte[0]);
            this.writeEntry(out, MANIFEST_NAME, content);
        }
        finally {
            this.storageMethod = oldStorageMethod;
        }
    }

    protected void copyEntry(JarOutputStream out, String name, Path path) throws IOException {
        if (!this.names.contains(name)) {
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path.toAbsolutePath() + " (No such file or directory)");
            }
            boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
            if (isDirectory && !name.endsWith("/")) {
                name = name + '/';
            }
            if (this.names.add(name)) {
                if (this.verbose) {
                    System.err.println("adding " + path);
                }
                long size = isDirectory ? 0L : Files.size(path);
                JarEntry outEntry = new JarEntry(name);
                long newtime = this.normalize ? this.normalizedTimestamp(name) : Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                outEntry.setTime(newtime);
                outEntry.setSize(size);
                if (size == 0L) {
                    outEntry.setMethod(0);
                    outEntry.setCrc(0L);
                    out.putNextEntry(outEntry);
                } else {
                    outEntry.setMethod(this.storageMethod);
                    if (this.storageMethod == 0) {
                        byte[] bytes = Files.readAllBytes(path);
                        CRC32 crc = new CRC32();
                        crc.update(bytes);
                        outEntry.setCrc(crc.getValue());
                        out.putNextEntry(outEntry);
                        out.write(bytes);
                    } else {
                        out.putNextEntry(outEntry);
                        Files.copy(path, out);
                    }
                }
                out.closeEntry();
            }
        }
    }
}

