/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.OptionsParser;
import com.google.devtools.build.buildjar.jarhelper.JarCreator;
import com.google.devtools.build.buildjar.javac.JavacOptions;
import com.google.devtools.build.buildjar.proto.JavaCompilation;
import com.google.devtools.build.lib.view.proto.Deps;
import com.google.devtools.build.lib.worker.WorkerProtocol;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class VanillaJavaBuilder
implements Closeable {
    private final Map<Path, FileSystem> filesystems = new HashMap<Path, FileSystem>();

    private FileSystem getJarFileSystem(Path sourceJar) throws IOException {
        FileSystem fs = this.filesystems.get(sourceJar);
        if (fs == null) {
            fs = FileSystems.newFileSystem(sourceJar, (ClassLoader)null);
            this.filesystems.put(sourceJar, fs);
        }
        return fs;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 1 && args[0].equals("--persistent_worker")) {
            System.exit(VanillaJavaBuilder.runPersistentWorker());
        } else {
            try (VanillaJavaBuilder builder = new VanillaJavaBuilder();){
                VanillaJavaBuilderResult result = builder.run(ImmutableList.copyOf(args));
                System.err.print(result.output());
                System.exit(result.ok() ? 0 : 1);
            }
        }
    }

    private static int runPersistentWorker() {
        try {
            WorkerProtocol.WorkRequest request;
            while ((request = WorkerProtocol.WorkRequest.parseDelimitedFrom(System.in)) != null) {
                VanillaJavaBuilderResult result;
                try (VanillaJavaBuilder builder = new VanillaJavaBuilder();){
                    result = builder.run(request.getArgumentsList());
                }
                WorkerProtocol.WorkResponse response = WorkerProtocol.WorkResponse.newBuilder().setOutput(result.output()).setExitCode(result.ok() ? 0 : 1).setRequestId(request.getRequestId()).build();
                response.writeDelimitedTo(System.out);
                System.out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public VanillaJavaBuilderResult run(List<String> args) throws IOException {
        OutputStream os;
        boolean ok;
        OptionsParser optionsParser;
        try {
            optionsParser = new OptionsParser(args);
        }
        catch (InvalidCommandLineException e) {
            return new VanillaJavaBuilderResult(false, e.getMessage());
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StringWriter output = new StringWriter();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        Path tempDir = Files.createTempDirectory("_tmp", new FileAttribute[0]);
        Path nativeHeaderDir = tempDir.resolve("native_headers");
        Files.createDirectories(nativeHeaderDir, new FileAttribute[0]);
        Path sourceGenDir = tempDir.resolve("sources");
        Files.createDirectories(sourceGenDir, new FileAttribute[0]);
        Path classDir = tempDir.resolve("classes");
        Files.createDirectories(classDir, new FileAttribute[0]);
        try (StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(diagnosticCollector, Locale.ENGLISH, StandardCharsets.UTF_8);){
            VanillaJavaBuilder.setLocations(optionsParser, fileManager, nativeHeaderDir, sourceGenDir, classDir);
            ImmutableList<JavaFileObject> sources = this.getSources(optionsParser, fileManager);
            if (sources.isEmpty()) {
                ok = true;
            } else {
                JavaCompiler.CompilationTask task = javaCompiler.getTask(new PrintWriter((Writer)output, true), fileManager, diagnosticCollector, JavacOptions.removeBazelSpecificFlags(optionsParser.getJavacOpts()), ImmutableList.of(), sources);
                VanillaJavaBuilder.setProcessors(optionsParser, fileManager, task);
                ok = task.call();
            }
        }
        if (ok) {
            VanillaJavaBuilder.writeOutput(classDir, optionsParser);
            VanillaJavaBuilder.writeNativeHeaderOutput(optionsParser, nativeHeaderDir);
        }
        VanillaJavaBuilder.writeGeneratedSourceOutput(sourceGenDir, optionsParser);
        if (optionsParser.getOutputDepsProtoFile() != null) {
            os = Files.newOutputStream(Paths.get(optionsParser.getOutputDepsProtoFile(), new String[0]), new OpenOption[0]);
            try {
                Deps.Dependencies.newBuilder().setRuleLabel(optionsParser.getTargetLabel()).setSuccess(ok).build().writeTo(os);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        if (optionsParser.getManifestProtoPath() != null) {
            os = Files.newOutputStream(Paths.get(optionsParser.getManifestProtoPath(), new String[0]), new OpenOption[0]);
            try {
                JavaCompilation.Manifest.getDefaultInstance().writeTo(os);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            String code = diagnostic.getCode();
            if (code.startsWith("compiler.note.deprecated") || code.startsWith("compiler.note.unchecked") || code.equals("compiler.warn.sun.proprietary")) continue;
            StringBuilder message = new StringBuilder();
            if (diagnostic.getSource() != null) {
                message.append(((JavaFileObject)diagnostic.getSource()).getName());
                if (diagnostic.getLineNumber() != -1L) {
                    message.append(':').append(diagnostic.getLineNumber());
                }
                message.append(": ");
            }
            message.append(diagnostic.getKind().toString().toLowerCase(Locale.ENGLISH));
            message.append(": ").append(diagnostic.getMessage(Locale.ENGLISH)).append(System.lineSeparator());
            output.write(message.toString());
        }
        return new VanillaJavaBuilderResult(ok, output.toString());
    }

    private ImmutableList<JavaFileObject> getSources(OptionsParser optionsParser, StandardJavaFileManager fileManager) throws IOException {
        final ImmutableList.Builder sources = ImmutableList.builder();
        sources.addAll(fileManager.getJavaFileObjectsFromStrings(optionsParser.getSourceFiles()));
        for (String sourceJar : optionsParser.getSourceJars()) {
            for (final Path root : this.getJarFileSystem(Paths.get(sourceJar, new String[0])).getRootDirectories()) {
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (path.getFileName().toString().endsWith(".java")) {
                            sources.add(new SourceJarFileObject(root, path));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        return sources.build();
    }

    private static void setLocations(OptionsParser optionsParser, StandardJavaFileManager fileManager, Path nativeHeaderDir, Path sourceGenDir, Path classDir) throws IOException {
        fileManager.setLocation(StandardLocation.CLASS_PATH, VanillaJavaBuilder.toFiles(optionsParser.getClassPath()));
        ImmutableList<File> bootClassPath = VanillaJavaBuilder.toFiles(optionsParser.getBootClassPath());
        if (!Iterables.isEmpty(bootClassPath)) {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
        }
        fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, VanillaJavaBuilder.toFiles(optionsParser.getProcessorPath()));
        VanillaJavaBuilder.setOutputLocation(fileManager, StandardLocation.SOURCE_OUTPUT, sourceGenDir);
        if (optionsParser.getNativeHeaderOutput() != null) {
            VanillaJavaBuilder.setOutputLocation(fileManager, StandardLocation.NATIVE_HEADER_OUTPUT, nativeHeaderDir);
        }
        VanillaJavaBuilder.setOutputLocation(fileManager, StandardLocation.CLASS_OUTPUT, classDir);
    }

    private static void setOutputLocation(StandardJavaFileManager fileManager, StandardLocation location, Path path) throws IOException {
        VanillaJavaBuilder.createOutputDirectory(path);
        fileManager.setLocation(location, ImmutableList.of(path.toFile()));
    }

    private static void setProcessors(OptionsParser optionsParser, StandardJavaFileManager fileManager, JavaCompiler.CompilationTask task) {
        ClassLoader processorLoader = fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        ImmutableList.Builder processors = ImmutableList.builder();
        for (String processor : optionsParser.getProcessorNames()) {
            try {
                processors.add((Processor)processorLoader.loadClass(processor).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
        task.setProcessors(processors.build());
    }

    private static void writeGeneratedSourceOutput(Path sourceGenDir, OptionsParser optionsParser) throws IOException {
        if (optionsParser.getGeneratedSourcesOutputJar() == null) {
            return;
        }
        JarCreator jar = new JarCreator(optionsParser.getGeneratedSourcesOutputJar());
        jar.setNormalize(true);
        jar.setCompression(optionsParser.compressJar());
        jar.addDirectory(sourceGenDir);
        jar.execute();
    }

    private static void writeNativeHeaderOutput(OptionsParser optionsParser, Path nativeHeaderDir) throws IOException {
        if (optionsParser.getNativeHeaderOutput() == null) {
            return;
        }
        JarCreator jar = new JarCreator(optionsParser.getNativeHeaderOutput());
        try {
            jar.setNormalize(true);
            jar.setCompression(optionsParser.compressJar());
            jar.addDirectory(nativeHeaderDir);
        }
        finally {
            jar.execute();
        }
    }

    private static void writeOutput(Path classDir, OptionsParser optionsParser) throws IOException {
        JarCreator jar = new JarCreator(optionsParser.getOutputJar());
        jar.setNormalize(true);
        jar.setCompression(optionsParser.compressJar());
        jar.addDirectory(classDir);
        jar.execute();
    }

    private static ImmutableList<File> toFiles(List<String> classPath) {
        if (classPath == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder files = ImmutableList.builder();
        for (String path : classPath) {
            files.add(new File(path));
        }
        return files.build();
    }

    @Override
    public void close() throws IOException {
        for (FileSystem fs : this.filesystems.values()) {
            fs.close();
        }
    }

    private static void createOutputDirectory(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            try {
                MoreFiles.deleteRecursively(dir, RecursiveDeleteOption.ALLOW_INSECURE);
            }
            catch (IOException e) {
                throw new IOException("Cannot clean output directory '" + dir + "'", e);
            }
        }
        Files.createDirectories(dir, new FileAttribute[0]);
    }

    private static class SourceJarFileObject
    extends SimpleJavaFileObject {
        private final Path path;

        public SourceJarFileObject(Path root, Path path) {
            super(URI.create("file:/" + root + "!" + root.resolve(path)), JavaFileObject.Kind.SOURCE);
            this.path = path;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return Files.readString(this.path);
        }
    }

    public static class VanillaJavaBuilderResult {
        private final boolean ok;
        private final String output;

        public VanillaJavaBuilderResult(boolean ok, String output) {
            this.ok = ok;
            this.output = output;
        }

        public boolean ok() {
            return this.ok;
        }

        public String output() {
            return this.output;
        }
    }
}

