/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.javac.JavacOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class OptionsParser {
    private final List<String> javacOpts = new ArrayList<String>();
    private final Set<String> directJars = new LinkedHashSet<String>();
    private String strictJavaDeps;
    private String fixDepsTool;
    private String outputDepsProtoFile;
    private final Set<String> depsArtifacts = new LinkedHashSet<String>();
    private ReduceClasspathMode reduceClasspathMode = ReduceClasspathMode.NONE;
    private int fullClasspathLength = -1;
    private int reducedClasspathLength = -1;
    private String generatedSourcesOutputJar;
    private String manifestProtoPath;
    private final List<String> sourceFiles = new ArrayList<String>();
    private final List<String> sourceJars = new ArrayList<String>();
    private final List<String> classPath = new ArrayList<String>();
    private final List<String> sourcePath = new ArrayList<String>();
    private final List<String> bootClassPath = new ArrayList<String>();
    private String system;
    private final List<String> processorPath = new ArrayList<String>();
    private final List<String> processorNames = new ArrayList<String>();
    private final List<String> builtinProcessorNames = new ArrayList<String>();
    private String outputJar;
    @Nullable
    private String nativeHeaderOutput;
    private final Map<String, List<String>> postProcessors = new LinkedHashMap<String, List<String>>();
    private boolean compressJar;
    private String targetLabel;
    private String injectingRuleKind;
    @Nullable
    private final JavacOptions normalizer;
    private static final Splitter CLASSPATH_SPLITTER = Splitter.on(File.pathSeparatorChar).trimResults().omitEmptyStrings();

    public OptionsParser(List<String> args) throws InvalidCommandLineException, IOException {
        this(args, null);
    }

    public OptionsParser(List<String> args, @Nullable JavacOptions normalizer) throws InvalidCommandLineException, IOException {
        this.normalizer = normalizer;
        this.processCommandlineArgs(OptionsParser.expandArguments(args));
    }

    private void processCommandlineArgs(Deque<String> argQueue) throws InvalidCommandLineException {
        String arg = argQueue.pollFirst();
        while (arg != null) {
            switch (arg) {
                case "--javacopts": {
                    OptionsParser.readJavacopts(this.javacOpts, argQueue);
                    this.sourcePathFromJavacOpts();
                    break;
                }
                case "--direct_dependencies": {
                    OptionsParser.collectFlagArguments(this.directJars, argQueue, "--");
                    break;
                }
                case "--strict_java_deps": {
                    this.strictJavaDeps = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--experimental_fix_deps_tool": {
                    this.fixDepsTool = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--output_deps_proto": {
                    this.outputDepsProtoFile = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--deps_artifacts": {
                    OptionsParser.collectFlagArguments(this.depsArtifacts, argQueue, "--");
                    break;
                }
                case "--reduce_classpath": {
                    this.reduceClasspathMode = ReduceClasspathMode.JAVABUILDER_REDUCED;
                    break;
                }
                case "--reduce_classpath_mode": {
                    this.reduceClasspathMode = ReduceClasspathMode.valueOf(OptionsParser.getArgument(argQueue, arg));
                    break;
                }
                case "--full_classpath_length": {
                    this.fullClasspathLength = Integer.parseInt(OptionsParser.getArgument(argQueue, arg));
                    break;
                }
                case "--reduced_classpath_length": {
                    this.reducedClasspathLength = Integer.parseInt(OptionsParser.getArgument(argQueue, arg));
                    break;
                }
                case "--generated_sources_output": {
                    this.generatedSourcesOutputJar = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--output_manifest_proto": {
                    this.manifestProtoPath = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--sources": {
                    OptionsParser.collectFlagArguments(this.sourceFiles, argQueue, "-");
                    break;
                }
                case "--source_jars": {
                    OptionsParser.collectFlagArguments(this.sourceJars, argQueue, "-");
                    break;
                }
                case "--classpath": {
                    OptionsParser.collectFlagArguments(this.classPath, argQueue, "-");
                    break;
                }
                case "--sourcepath": {
                    OptionsParser.collectFlagArguments(this.sourcePath, argQueue, "-");
                    break;
                }
                case "--bootclasspath": {
                    OptionsParser.collectFlagArguments(this.bootClassPath, argQueue, "-");
                    break;
                }
                case "--system": {
                    this.system = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--processorpath": {
                    OptionsParser.collectFlagArguments(this.processorPath, argQueue, "-");
                    break;
                }
                case "--processors": {
                    OptionsParser.collectProcessorArguments(this.processorNames, argQueue, "-");
                    break;
                }
                case "--builtin_processors": {
                    OptionsParser.collectProcessorArguments(this.builtinProcessorNames, argQueue, "-");
                    break;
                }
                case "--output": {
                    this.outputJar = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--native_header_output": {
                    this.nativeHeaderOutput = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--post_processor": {
                    this.addExternalPostProcessor(argQueue, arg);
                    break;
                }
                case "--compress_jar": {
                    this.compressJar = true;
                    break;
                }
                case "--target_label": {
                    this.targetLabel = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                case "--injecting_rule_kind": {
                    this.injectingRuleKind = OptionsParser.getArgument(argQueue, arg);
                    break;
                }
                default: {
                    throw new InvalidCommandLineException("unknown option : '" + arg + "'");
                }
            }
            arg = argQueue.pollFirst();
        }
    }

    private void sourcePathFromJavacOpts() {
        Iterator<String> it = this.javacOpts.iterator();
        while (it.hasNext()) {
            String curr = it.next();
            if (!curr.equals("-sourcepath") || !it.hasNext()) continue;
            it.remove();
            Iterables.addAll(this.sourcePath, CLASSPATH_SPLITTER.split(it.next()));
            it.remove();
        }
    }

    private static Deque<String> expandArguments(List<String> args) throws IOException {
        ArrayDeque<String> expanded = new ArrayDeque<String>(args.size());
        for (String arg : args) {
            OptionsParser.expandArgument(expanded, arg);
        }
        return expanded;
    }

    private static void expandArgument(Deque<String> expanded, String arg) throws IOException {
        if (arg.startsWith("@@")) {
            expanded.add(arg.substring(1));
        } else if (arg.startsWith("@")) {
            for (String line : Files.readAllLines(Paths.get(arg.substring(1), new String[0]), StandardCharsets.UTF_8)) {
                if (line.length() <= 0) continue;
                OptionsParser.expandArgument(expanded, line);
            }
        } else {
            expanded.add(arg);
        }
    }

    private static void collectFlagArguments(Collection<String> output, Deque<String> args, String terminatorPrefix) {
        String arg = args.pollFirst();
        while (arg != null) {
            if (arg.startsWith(terminatorPrefix)) {
                args.addFirst(arg);
                break;
            }
            output.add(arg);
            arg = args.pollFirst();
        }
    }

    private static void readJavacopts(List<String> javacopts, Deque<String> argumentDeque) {
        while (!argumentDeque.isEmpty()) {
            String arg = argumentDeque.pollFirst();
            if (arg.equals("--")) {
                return;
            }
            javacopts.add(arg);
        }
        throw new IllegalArgumentException("javacopts should be terminated by `--`");
    }

    private static void collectProcessorArguments(List<String> output, Deque<String> args, String terminatorPrefix) throws InvalidCommandLineException {
        String arg = args.pollFirst();
        while (arg != null) {
            if (arg.startsWith(terminatorPrefix)) {
                args.addFirst(arg);
                break;
            }
            if (arg.contains(",")) {
                throw new InvalidCommandLineException("processor argument may not contain commas: " + arg);
            }
            output.add(arg);
            arg = args.pollFirst();
        }
    }

    private static String getArgument(Deque<String> args, String arg) throws InvalidCommandLineException {
        try {
            return args.remove();
        }
        catch (NoSuchElementException e) {
            throw new InvalidCommandLineException(arg + ": missing argument", e);
        }
    }

    private void addExternalPostProcessor(Deque<String> args, String arg) throws InvalidCommandLineException {
        String processorName = OptionsParser.getArgument(args, arg);
        ArrayList<String> arguments = new ArrayList<String>();
        OptionsParser.collectFlagArguments(arguments, args, "--");
        this.postProcessors.put(processorName, arguments);
    }

    public List<String> getJavacOpts() {
        return this.normalizer != null ? this.normalizer.normalize(this.javacOpts) : this.javacOpts;
    }

    public Set<String> directJars() {
        return this.directJars;
    }

    public String getStrictJavaDeps() {
        return this.strictJavaDeps;
    }

    public String getFixDepsTool() {
        return this.fixDepsTool;
    }

    public String getOutputDepsProtoFile() {
        return this.outputDepsProtoFile;
    }

    public Set<String> getDepsArtifacts() {
        return this.depsArtifacts;
    }

    public ReduceClasspathMode reduceClasspathMode() {
        return this.reduceClasspathMode;
    }

    public int fullClasspathLength() {
        return this.fullClasspathLength;
    }

    public int reducedClasspathLength() {
        return this.reducedClasspathLength;
    }

    public String getGeneratedSourcesOutputJar() {
        return this.generatedSourcesOutputJar;
    }

    public String getManifestProtoPath() {
        return this.manifestProtoPath;
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public List<String> getSourceJars() {
        return this.sourceJars;
    }

    public List<String> getClassPath() {
        return this.classPath;
    }

    public List<String> getBootClassPath() {
        return this.bootClassPath;
    }

    public String getSystem() {
        return this.system;
    }

    public List<String> getSourcePath() {
        return this.sourcePath;
    }

    public List<String> getProcessorPath() {
        return this.processorPath;
    }

    public List<String> getProcessorNames() {
        return this.processorNames;
    }

    public List<String> getBuiltinProcessorNames() {
        return this.builtinProcessorNames;
    }

    public String getOutputJar() {
        return this.outputJar;
    }

    @Nullable
    public String getNativeHeaderOutput() {
        return this.nativeHeaderOutput;
    }

    public Map<String, List<String>> getPostProcessors() {
        return this.postProcessors;
    }

    public boolean compressJar() {
        return this.compressJar;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public String getInjectingRuleKind() {
        return this.injectingRuleKind;
    }

    public static enum ReduceClasspathMode {
        BAZEL_REDUCED,
        BAZEL_FALLBACK,
        JAVABUILDER_REDUCED,
        NONE;

    }
}

